/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelSummary.class})
public abstract class LevelSummaryMixin {
    @Shadow
    @Final
    private LevelSettings settings;
    @Shadow
    @Final
    private String levelId;

    @Shadow
    public abstract String getLevelName();

    @Shadow
    public abstract MutableComponent getWorldVersionName();

    @Inject(method={"createInfo"}, at={@At(value="RETURN")}, cancellable=true)
    private void narrativecraft$expandWorldInfo(CallbackInfoReturnable<Component> cir) {
        NarrativeWorldOption option = NarrativeCraftFile.getNarrativeCraftWorldVersion(this.levelId, this.getWorldVersionName().getString());
        if (option == null) {
            return;
        }
        if (option.stringMcVersion.isEmpty()) {
            return;
        }
        Component original = (Component)cir.getReturnValue();
        MutableComponent versionComp = !SharedConstants.getCurrentVersion().name().equals(option.stringMcVersion) ? Component.literal((String)option.stringMcVersion).withStyle(ChatFormatting.RED) : Component.literal((String)option.stringMcVersion);
        MutableComponent versionNC = Component.literal((String)"NC ver: ").append((Component)versionComp).append(", ").append(original);
        cir.setReturnValue((Object)versionNC);
    }
}

