/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class PoseAction
extends Action {
    private final Pose pose;
    private final Pose previousPose;

    public PoseAction(int waitTick, Pose pose, Pose previousPose) {
        super(waitTick, ActionType.POSE);
        this.pose = pose;
        this.previousPose = previousPose;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.pose != Pose.SLEEPING) {
                livingEntity.clearSleepingPos();
            }
            livingEntity.setPose(this.pose);
        }
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.previousPose != null) {
                playbackData.getEntity().setPose(this.previousPose);
                if (this.previousPose != Pose.SLEEPING) {
                    livingEntity.clearSleepingPos();
                }
            }
        }
    }

    public Pose getPreviousPose() {
        return this.previousPose;
    }

    public Pose getPose() {
        return this.pose;
    }
}

