/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.util.Translation;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.Component;

public class ChangeSkinLinkScreen
extends OptionsSubScreen {
    private SkinList skinList;
    private final CharacterRuntime characterRuntime;
    private final Consumer<String> stringCallback;

    public ChangeSkinLinkScreen(Screen lastScreen, CharacterRuntime characterRuntime, Consumer<String> stringCallback) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Translation.message("screen.change_skin_link.title", characterRuntime.getCharacterStory().getName()));
        this.characterRuntime = characterRuntime;
        this.stringCallback = stringCallback;
    }

    protected void addContents() {
        this.skinList = (SkinList)this.layout.addToContents((LayoutElement)new SkinList(this.minecraft, this.characterRuntime.getCharacterSkinController().getSkins()));
    }

    protected void addOptions() {
    }

    protected void repositionElements() {
        super.repositionElements();
        this.skinList.updateSize(this.width, this.layout);
    }

    public void onClose() {
        SkinList.Entry entry = (SkinList.Entry)this.skinList.getSelected();
        if (entry != null) {
            File selectedSkin = entry.skin;
            this.characterRuntime.getCharacterSkinController().setCurrentSkin(selectedSkin);
            this.handleSkin(selectedSkin.getName());
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    private void handleSkin(String skin) {
        this.stringCallback.accept(skin);
    }

    class SkinList
    extends ObjectSelectionList<Entry> {
        public SkinList(Minecraft minecraft, List<File> skins) {
            super(minecraft, ChangeSkinLinkScreen.this.width, ChangeSkinLinkScreen.this.height - 33 - 53, 33, 18);
            String selectedSkin = ChangeSkinLinkScreen.this.characterRuntime.getCharacterSkinController().getCurrentSkin() != null ? ChangeSkinLinkScreen.this.characterRuntime.getCharacterSkinController().getCurrentSkin().getName() : "";
            skins.forEach(file -> {
                Entry entry = new Entry((File)file);
                this.addEntry((AbstractSelectionList.Entry)entry);
                if (selectedSkin.equalsIgnoreCase(file.getName())) {
                    this.setSelected((AbstractSelectionList.Entry)entry);
                }
            });
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final File skin;

            public Entry(File skin) {
                this.skin = skin;
            }

            public void render(GuiGraphics p_345300_, int p_345469_, int p_345328_, int p_345700_, int p_345311_, int p_345185_, int p_344805_, int p_345963_, boolean p_345912_, float p_346091_) {
                p_345300_.drawCenteredString(ChangeSkinLinkScreen.this.font, this.skin.getName().split("\\.")[0], SkinList.this.width / 2, p_345328_ + p_345185_ / 2 - 4, -1);
            }

            public boolean keyPressed(int p_346403_, int p_345881_, int p_345858_) {
                if (CommonInputs.selected((int)p_346403_)) {
                    this.select();
                    ChangeSkinLinkScreen.this.onClose();
                    return true;
                }
                return super.keyPressed(p_346403_, p_345881_, p_345858_);
            }

            public boolean mouseClicked(double p_344965_, double p_345385_, int p_345080_) {
                this.select();
                return super.mouseClicked(p_344965_, p_345385_, p_345080_);
            }

            private void select() {
                SkinList.this.setSelected((AbstractSelectionList.Entry)this);
            }

            public Component getNarration() {
                return Component.literal((String)this.skin.getName());
            }
        }
    }
}

