/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.keys;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.keys.ModKeys;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PressKeyListener {
    public static void onPressKey(Minecraft minecraft) {
        ModKeys.handleKeyPress(ModKeys.OPEN_STORY_MANAGER, () -> {
            if (!minecraft.player.hasPermissions(2)) {
                return;
            }
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
            if (playerSession == null) {
                return;
            }
            if (playerSession.getStoryHandler() != null) {
                return;
            }
            if (playerSession.getController() != null) {
                playerSession.getPlayer().sendSystemMessage((Component)Translation.message("session.controller_set", new Object[0]));
                return;
            }
            if (playerSession.isSessionSet()) {
                minecraft.setScreen((Screen)new ScenesMenuScreen(playerSession.getScene()));
            } else {
                minecraft.setScreen((Screen)new ChaptersScreen());
            }
        });
        ModKeys.handleKeyPress(ModKeys.OPEN_CONTROLLER_SCREEN, () -> {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
            if (playerSession == null) {
                return;
            }
            if (playerSession.getStoryHandler() != null) {
                return;
            }
            if (playerSession.getController() == null) {
                return;
            }
            minecraft.setScreen(playerSession.getController().getControllerScreen());
        });
        ModKeys.handleKeyPress(0, minecraft.mouseHandler.isLeftPressed(), () -> {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
            PressKeyListener.nextStory(playerSession);
        });
        ModKeys.handleKeyPress(ModKeys.NEXT_DIALOG, () -> {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
            PressKeyListener.nextStory(playerSession);
        });
        ModKeys.handleKeyPress(ModKeys.STORY_DEBUG, () -> {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
            if (playerSession == null) {
                return;
            }
            if (!playerSession.isSessionSet()) {
                minecraft.player.displayClientMessage((Component)Translation.message("session.not_set", new Object[0]), false);
                return;
            }
            StoryHandler storyHandler = playerSession.getStoryHandler();
            if (storyHandler == null) {
                return;
            }
            playerSession.setShowDebugHud(!playerSession.isShowDebugHud());
        });
        ModKeys.handleKeyPress(ModKeys.START_ANIMATION_RECORDING, () -> {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
            if (playerSession == null) {
                return;
            }
            if (!playerSession.isSessionSet()) {
                minecraft.player.displayClientMessage((Component)Translation.message("session.not_set", new Object[0]), false);
                return;
            }
            Recording recording = NarrativeCraftMod.getInstance().getRecordingManager().getRecording((Entity)playerSession.getPlayer());
            if (recording != null && recording.isRecording()) {
                minecraft.player.displayClientMessage((Component)Translation.message("record.start.already_recording", new Object[0]).withStyle(ChatFormatting.RED), false);
                return;
            }
            if (recording == null) {
                recording = new Recording((LivingEntity)playerSession.getPlayer(), playerSession);
            }
            recording.start();
            NarrativeCraftMod.getInstance().getRecordingManager().addRecording(recording);
            minecraft.player.displayClientMessage((Component)Translation.message("record.start.success", new Object[0]), false);
        });
        ModKeys.handleKeyPress(ModKeys.STOP_ANIMATION_RECORDING, () -> {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
            if (playerSession == null) {
                return;
            }
            Recording recording = NarrativeCraftMod.getInstance().getRecordingManager().getRecording((Entity)playerSession.getPlayer());
            if (recording == null || !recording.isRecording()) {
                minecraft.player.displayClientMessage((Component)Translation.message("record.stop.no_recording", new Object[0]).withStyle(ChatFormatting.RED), false);
                return;
            }
            recording.stop();
            minecraft.player.displayClientMessage((Component)Translation.message("record.stop.success", new Object[0]), false);
        });
    }

    private static void nextStory(PlayerSession playerSession) {
        if (playerSession == null) {
            return;
        }
        DialogRenderer dialogRenderer = playerSession.getDialogRenderer();
        if (dialogRenderer == null) {
            return;
        }
        if (dialogRenderer.isAnimating()) {
            return;
        }
        if (dialogRenderer.isNoSkip()) {
            return;
        }
        if (!dialogRenderer.getDialogScrollText().isFinished()) {
            dialogRenderer.getDialogScrollText().forceFinish();
            return;
        }
        if (playerSession.getStoryHandler() == null) {
            return;
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        NarrativeCraftMod.server.execute(storyHandler::next);
    }
}

