/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.mainScreen;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframesBase;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.data.MainScreenData;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.narrative.keyframes.mainScreen.MainScreenKeyframe;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.screens.controller.mainScreen.MainScreenControllerScreen;
import fr.loudo.narrativecraft.screens.controller.mainScreen.MainScreenKeyframeOptionsScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class MainScreenController
extends AbstractKeyframesBase<MainScreenKeyframe> {
    private final MainScreenData mainScreenData;

    public MainScreenController(Environment environment, Player player, MainScreenData mainScreenData) {
        super(environment, player);
        this.mainScreenData = mainScreenData;
        if (mainScreenData.getKeyframe() != null) {
            this.keyframes.add(mainScreenData.getKeyframe());
        }
        if (mainScreenData.getKeyframeTrigger() != null) {
            this.keyframeTriggers.add(mainScreenData.getKeyframeTrigger());
        }
        this.characterStoryDataList.addAll(mainScreenData.getCharacterStoryDataList());
        this.hudMessage = Translation.message("controller.main_screen.hud", new Object[0]).getString();
    }

    public void addKeyframe() {
        MainScreenKeyframe keyframe = new MainScreenKeyframe(0, this.getKeyframeLocationFromPlayer());
        keyframe.showKeyframe(this.playerSession.getPlayer());
        this.keyframes.add(keyframe);
    }

    @Override
    public void addKeyframeTrigger(int tick, String commands) {
        if (this.keyframeTriggers.isEmpty()) {
            super.addKeyframeTrigger(tick, commands);
        }
    }

    @Override
    public Screen keyframeOptionScreen(Keyframe keyframe, boolean hide) {
        return new MainScreenKeyframeOptionsScreen((MainScreenKeyframe)keyframe, this, this.playerSession, hide);
    }

    @Override
    public void startSession() {
        this.stopCurrentSession();
        this.playerSession.setController(this);
        for (CharacterStoryData characterStoryData : this.characterStoryDataList) {
            characterStoryData.spawn(this.playerSession.getPlayer().level(), this.environment);
            this.playerSession.getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
        }
        if (this.environment == Environment.PRODUCTION) {
            if (!this.keyframes.isEmpty()) {
                this.playerSession.setCurrentCamera(((MainScreenKeyframe)this.keyframes.getFirst()).getKeyframeLocation());
            }
            if (!this.keyframeTriggers.isEmpty()) {
                List<String> tags = ((KeyframeTrigger)this.keyframeTriggers.getFirst()).getCommandsToList();
                for (String tag : tags) {
                    InkAction inkAction = InkActionRegistry.findByCommand(tag);
                    if (inkAction == null) continue;
                    inkAction.validateAndExecute(tag, this.playerSession);
                }
            }
            return;
        }
        if (!this.keyframes.isEmpty()) {
            ((MainScreenKeyframe)this.keyframes.getFirst()).showKeyframe(this.playerSession.getPlayer());
        }
        if (!this.keyframeTriggers.isEmpty()) {
            ((KeyframeTrigger)this.keyframeTriggers.getFirst()).showKeyframe(this.playerSession.getPlayer());
        }
        Location location = null;
        if (!this.keyframes.isEmpty()) {
            location = ((MainScreenKeyframe)this.keyframes.getFirst()).getKeyframeLocation().asLocation();
        } else if (!this.keyframeTriggers.isEmpty()) {
            location = ((KeyframeTrigger)this.keyframeTriggers.getFirst()).getKeyframeLocation().asLocation();
        } else if (!this.characterStoryDataList.isEmpty()) {
            location = ((CharacterStoryData)this.characterStoryDataList.getFirst()).getLocation();
        }
        if (location != null) {
            this.playerSession.getPlayer().teleportTo(location.x(), location.y(), location.z());
        }
    }

    @Override
    public void stopSession(boolean save) {
        this.playerSession.setController(null);
        for (CharacterStoryData characterStoryData : this.characterStoryDataList) {
            characterStoryData.kill();
        }
        this.playerSession.getCharacterRuntimes().removeAll(this.characterStoryDataList.stream().map(CharacterStoryData::getCharacterRuntime).toList());
        if (this.environment == Environment.PRODUCTION) {
            for (InkAction inkAction : this.playerSession.getInkActions()) {
                inkAction.stop();
            }
            this.playerSession.getInkActions().clear();
            this.playerSession.setCurrentCamera(null);
            return;
        }
        if (!this.keyframes.isEmpty()) {
            ((MainScreenKeyframe)this.keyframes.getFirst()).hideKeyframe(this.playerSession.getPlayer());
        }
        if (!this.keyframeTriggers.isEmpty()) {
            ((KeyframeTrigger)this.keyframeTriggers.getFirst()).hideKeyframe(this.playerSession.getPlayer());
        }
        if (save) {
            MainScreenKeyframe oldKeyframe = this.mainScreenData.getKeyframe();
            KeyframeTrigger oldKeyframeTrigger = this.mainScreenData.getKeyframeTrigger();
            MainScreenKeyframe keyframe = !this.keyframes.isEmpty() ? (MainScreenKeyframe)this.keyframes.getFirst() : null;
            KeyframeTrigger keyframeTrigger = !this.keyframeTriggers.isEmpty() ? (KeyframeTrigger)this.keyframeTriggers.getFirst() : null;
            List<CharacterStoryData> oldCharacterStoryData = this.mainScreenData.getCharacterStoryDataList();
            this.mainScreenData.getCharacterStoryDataList().clear();
            try {
                this.mainScreenData.setKeyframe(keyframe);
                this.mainScreenData.setKeyframeTrigger(keyframeTrigger);
                this.mainScreenData.getCharacterStoryDataList().addAll(this.characterStoryDataList);
                NarrativeCraftFile.updateMainScreenBackground(this.mainScreenData, this.playerSession.getScene());
                for (CharacterStoryData characterStoryData : this.mainScreenData.getCharacterStoryDataList()) {
                    characterStoryData.setSkinName(characterStoryData.getCharacterRuntime().getSkinName());
                }
                this.playerSession.getPlayer().sendSystemMessage((Component)Translation.message("controller.saved", new Object[0]));
            }
            catch (IOException e) {
                this.mainScreenData.setKeyframe(oldKeyframe);
                this.mainScreenData.setKeyframeTrigger(oldKeyframeTrigger);
                this.mainScreenData.getCharacterStoryDataList().addAll(oldCharacterStoryData);
                for (CharacterStoryData characterStoryData : this.mainScreenData.getCharacterStoryDataList()) {
                    characterStoryData.setSkinName(characterStoryData.getCharacterRuntime().getOldSkinName());
                }
                Util.sendCrashMessage((Player)this.playerSession.getPlayer(), e);
            }
        } else {
            for (CharacterStoryData characterStoryData : this.mainScreenData.getCharacterStoryDataList()) {
                characterStoryData.setSkinName(characterStoryData.getCharacterRuntime().getOldSkinName());
            }
        }
    }

    public MainScreenKeyframe getKeyframe() {
        return this.keyframes.isEmpty() ? null : (MainScreenKeyframe)this.keyframes.getFirst();
    }

    public KeyframeTrigger getKeyframeTrigger() {
        return this.keyframeTriggers.isEmpty() ? null : (KeyframeTrigger)this.keyframeTriggers.getFirst();
    }

    @Override
    public Screen getControllerScreen() {
        return new MainScreenControllerScreen(this);
    }

    public MainScreenData getMainScreenData() {
        return this.mainScreenData;
    }
}

