/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.events.OnRenderWorld;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@Mod(value="narrativecraft")
public class RenderWorldEvent {
    public RenderWorldEvent(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(RenderWorldEvent::onWorldRender);
    }

    private static void onWorldRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.mul((Matrix4fc)event.getModelViewMatrix());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        OnRenderWorld.renderWorld(new PoseStack(), event.getPartialTick().getGameTimeDeltaPartialTick(true));
        matrix4fstack.popMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }
}

