/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class FinishedStoryScreen
extends Screen {
    private static final ResourceLocation WINDOW_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/window.png");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final PlayerSession playerSession;

    public FinishedStoryScreen(PlayerSession playerSession) {
        super((Component)Component.literal((String)"Finished Story Screen"));
        this.playerSession = playerSession;
    }

    public void onClose() {
        MainScreen mainScreen = new MainScreen(this.playerSession, false, false);
        this.minecraft.setScreen((Screen)mainScreen);
    }

    protected void init() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, p_331557_ -> this.onClose()).width(200).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        super.render(guiGraphics, x, y, partialTick);
        int i = (this.width - 252) / 2;
        int j = (this.height - 140) / 2;
        this.renderInside(guiGraphics, x, y, i, j);
        this.renderWindow(guiGraphics, i, j);
    }

    private void renderInside(GuiGraphics guiGraphics, int mouseX, int mouseY, int offsetX, int offsetY) {
        int i = offsetX + 9 + 117;
        guiGraphics.fill(offsetX + 9, offsetY + 18, offsetX + 9 + 234, offsetY + 18 + 113, -16777216);
        int textPosY = offsetY + 18 + 56 - 4;
        MutableComponent mutableComponent = Translation.message("screen.finished_story.line_1", new Object[0]);
        Objects.requireNonNull(this.minecraft.font);
        guiGraphics.drawCenteredString(this.font, (Component)mutableComponent, i, textPosY - 9 / 2 - 2, -1);
        MutableComponent mutableComponent2 = Translation.message("screen.finished_story.line_2", new Object[0]);
        Objects.requireNonNull(this.minecraft.font);
        guiGraphics.drawCenteredString(this.font, (Component)mutableComponent2, i, textPosY + 9 / 2 + 2, -1);
    }

    public void renderWindow(GuiGraphics guiGraphics, int offsetX, int offsetY) {
        guiGraphics.blit(WINDOW_LOCATION, offsetX, offsetY, 0.0f, 0.0f, 252, 140, 256, 256);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

