/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.util.ScreenUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class PickElementScreen
extends Screen {
    private static final Component AVAILABLE_TITLE = Component.translatable((String)"pack.available.title");
    private static final Component SELECTED_TITLE = Component.translatable((String)"pack.selected.title");
    private final Screen lastScreen;
    private final List<? extends NarrativeEntry> narrativeEntry1;
    private final List<? extends NarrativeEntry> narrativeEntry2;
    private Button moveButton;
    private Button doneButton;
    private TransferableStorySelectionList availableList;
    private TransferableStorySelectionList selectedList;
    private StringWidget availableString;
    private StringWidget selectedString;
    private StringWidget headTitle;
    private Component availableMessage;
    private Component selectedMessage;
    private Component selector;
    private int initialY;
    Consumer<List<TransferableStorySelectionList.Entry>> onDone;

    public PickElementScreen(Screen lastScreen, Component title, Component selector, List<? extends NarrativeEntry> narrativeEntry1, List<? extends NarrativeEntry> narrativeEntry2, Consumer<List<TransferableStorySelectionList.Entry>> onDone) {
        super(title);
        this.selector = selector;
        this.narrativeEntry1 = narrativeEntry1;
        this.narrativeEntry2 = narrativeEntry2;
        this.onDone = onDone;
        this.lastScreen = lastScreen;
    }

    protected void init() {
        this.availableList = (TransferableStorySelectionList)this.addRenderableWidget((GuiEventListener)new TransferableStorySelectionList(this.minecraft, this.narrativeEntry1, 200, 240));
        this.selectedList = (TransferableStorySelectionList)this.addRenderableWidget((GuiEventListener)new TransferableStorySelectionList(this.minecraft, this.narrativeEntry2, 200, 240));
        this.availableList.setOtherList(this.selectedList);
        this.selectedList.setOtherList(this.availableList);
        this.moveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u25c0"), button -> {
            if (this.availableList.getSelected() != null) {
                TransferableStorySelectionList.Entry selected = (TransferableStorySelectionList.Entry)this.availableList.getSelected();
                this.availableList.children().remove((Object)selected);
                this.selectedList.children().add(selected);
                this.selectedList.setSelected(selected);
                this.availableList.setSelected((TransferableStorySelectionList.Entry)null);
                this.moveButton.setMessage((Component)Component.literal((String)"\u25c0"));
            } else if (this.selectedList.getSelected() != null) {
                TransferableStorySelectionList.Entry selected = (TransferableStorySelectionList.Entry)this.selectedList.getSelected();
                this.selectedList.children().remove((Object)selected);
                this.availableList.children().add(selected);
                this.availableList.setSelected(selected);
                this.selectedList.setSelected((TransferableStorySelectionList.Entry)null);
                this.moveButton.setMessage((Component)Component.literal((String)"\u25b6"));
            }
            this.moveButton.active = this.availableList.getSelected() != null || this.selectedList.getSelected() != null;
        }).width(20).build());
        this.moveButton.active = false;
        this.availableMessage = Component.literal((String)(this.selector.getString() + " " + AVAILABLE_TITLE.getString()));
        this.selectedMessage = Component.literal((String)(this.selector.getString() + " " + SELECTED_TITLE.getString()));
        this.availableString = (StringWidget)this.addRenderableWidget((GuiEventListener)ScreenUtils.text(this.availableMessage, this.font, 0, 0));
        this.selectedString = (StringWidget)this.addRenderableWidget((GuiEventListener)ScreenUtils.text(this.selectedMessage, this.font, 0, 0));
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onDone.accept(this.selectedList.children())).width(200).build());
        this.headTitle = (StringWidget)this.addRenderableWidget((GuiEventListener)ScreenUtils.text(this.title, this.font, 0, 0));
        this.initialY = this.availableList.getY() + 15;
        this.repositionElements();
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void repositionElements() {
        this.headTitle.setPosition(this.width / 2 - this.font.width((FormattedText)this.title) / 2, 12);
        this.availableList.setX(this.width / 2 - 15 - 200);
        this.availableList.setY(this.initialY);
        this.selectedList.setX(this.width / 2 + 15);
        this.selectedList.setY(this.initialY);
        this.moveButton.setPosition(this.width / 2 - this.moveButton.getWidth() / 2, this.selectedList.getY() + this.selectedList.getHeight() / 2 - this.moveButton.getHeight() / 2);
        this.availableString.setPosition(this.availableList.getX() + this.availableList.getWidth() / 2 - this.font.width((FormattedText)this.availableMessage) / 2, this.availableList.getY() - 15);
        this.selectedString.setPosition(this.selectedList.getX() + this.selectedList.getWidth() / 2 - this.font.width((FormattedText)this.selectedMessage) / 2, this.selectedList.getY() - 15);
        this.doneButton.setPosition(this.width / 2 - 100, this.height - 25);
    }

    public class TransferableStorySelectionList
    extends ObjectSelectionList<Entry> {
        private TransferableStorySelectionList otherList;

        public TransferableStorySelectionList(Minecraft minecraft, List<? extends NarrativeEntry> narrativeEntries, int width, int height) {
            super(minecraft, width, height, 33, 18);
            for (NarrativeEntry narrativeEntry : narrativeEntries) {
                Entry entry = new Entry(narrativeEntry);
                this.addEntry((AbstractSelectionList.Entry)entry);
            }
        }

        public void setOtherList(TransferableStorySelectionList otherList) {
            this.otherList = otherList;
        }

        public void setSelected(@Nullable Entry selected) {
            super.setSelected((AbstractSelectionList.Entry)selected);
            if (this.otherList != null && selected != null) {
                this.otherList.setSelected((Entry)null);
                if (Objects.equals((Object)this.otherList, (Object)PickElementScreen.this.selectedList)) {
                    PickElementScreen.this.moveButton.setMessage((Component)Component.literal((String)"\u25b6"));
                } else {
                    PickElementScreen.this.moveButton.setMessage((Component)Component.literal((String)"\u25c0"));
                }
                PickElementScreen.this.moveButton.active = true;
            }
        }

        public boolean mouseDragged(double p_313749_, double p_313887_, int p_313839_, double p_313844_, double p_313686_) {
            return super.mouseDragged(p_313749_, p_313887_, p_313839_, p_313844_, p_313686_);
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final NarrativeEntry narrativeEntry;

            public Entry(NarrativeEntry narrativeEntry) {
                this.narrativeEntry = narrativeEntry;
            }

            public Component getNarration() {
                return Component.literal((String)this.narrativeEntry.getName());
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                guiGraphics.drawCenteredString(((TransferableStorySelectionList)TransferableStorySelectionList.this).minecraft.font, this.narrativeEntry.getName(), left + 4 + TransferableStorySelectionList.this.width / 2, top + height / 2 - 4, -1);
            }

            public NarrativeEntry getNarrativeEntry() {
                return this.narrativeEntry;
            }
        }
    }
}

