/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cameraAngle;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cameraAngle.CameraAngleController;
import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.screens.components.EntryBoxScreen;
import fr.loudo.narrativecraft.screens.controller.cameraAngle.CameraAngleAddTemplateCharacter;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;

public class CameraAngleControllerScreen
extends Screen {
    private final int BUTTON_HEIGHT = 20;
    private final int BUTTON_WIDTH = 30;
    private final CameraAngleController cameraAngleController;

    public CameraAngleControllerScreen(CameraAngleController cameraAngleController) {
        super((Component)Component.literal((String)"Camera Angle Controller Screen"));
        this.cameraAngleController = cameraAngleController;
    }

    protected void init() {
        int spacing = 5;
        int totalWidth = 150 + spacing * 3;
        int startX = (this.width - totalWidth) / 2;
        int y = this.height - 50;
        Button addKeyframe = Button.builder((Component)ImageFontConstants.ADD_KEYFRAME, button -> {
            EntryBoxScreen screen = new EntryBoxScreen(this, (Component)Translation.message("global.name", new Object[0]), name -> {
                if (name.isEmpty()) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("camera_angle.name_no_empty", name, this.cameraAngleController.getCameraAngle().getName()));
                } else if (this.cameraAngleController.getKeyframeByName((String)name) != null) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("camera_angle.already_exists", name, this.cameraAngleController.getCameraAngle().getName()));
                } else {
                    this.cameraAngleController.createKeyframe((String)name);
                    this.onClose();
                }
            });
            this.minecraft.setScreen((Screen)screen);
        }).bounds(startX, y, 30, 20).build();
        addKeyframe.setTooltip(Tooltip.create((Component)Translation.message("tooltip.create_keyframe", new Object[0])));
        this.addRenderableWidget((GuiEventListener)addKeyframe);
        Button addCharacter = Button.builder((Component)ImageFontConstants.CHARACTER_ADD, button -> {
            ChooseCharacterScreen screen = new ChooseCharacterScreen((Screen)this, Translation.message("controller.camera_angle.add_character", this.cameraAngleController.getCameraAngle().getName()).getString(), null, this.cameraAngleController.getCameraAngle().getScene(), characterStory -> {
                if (characterStory == null) {
                    this.onClose();
                    return;
                }
                Location location = this.cameraAngleController.getPlayerSession().getPlayerPosition();
                CharacterStoryData characterStoryData = new CharacterStoryData((CharacterStory)characterStory, location, false, this.cameraAngleController.getCameraAngle().getScene());
                characterStoryData.setItems((LivingEntity)this.minecraft.player);
                characterStoryData.setEntityByte((Byte)this.minecraft.player.getEntityData().get(EntityAccessor.getDATA_SHARED_FLAGS_ID()));
                characterStoryData.setLivingEntityByte((Byte)this.minecraft.player.getEntityData().get(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS()));
                characterStoryData.spawn(this.cameraAngleController.getPlayerSession().getPlayer().level(), Environment.DEVELOPMENT);
                this.cameraAngleController.getCharacterStoryDataList().add(characterStoryData);
                this.minecraft.setScreen(null);
                this.cameraAngleController.getPlayerSession().getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
            });
            this.minecraft.setScreen((Screen)screen);
        }).bounds(startX + (30 + spacing) * 1, y, 30, 20).build();
        addCharacter.setTooltip(Tooltip.create((Component)Translation.message("tooltip.add_character", new Object[0])));
        this.addRenderableWidget((GuiEventListener)addCharacter);
        Button recordMenu = Button.builder((Component)ImageFontConstants.SETTINGS, button -> {
            CameraAngleAddTemplateCharacter cameraAngleAddRecord = new CameraAngleAddTemplateCharacter((Screen)this, this.cameraAngleController);
            this.minecraft.setScreen((Screen)cameraAngleAddRecord);
        }).bounds(startX + (30 + spacing) * 2, y, 30, 20).build();
        recordMenu.setTooltip(Tooltip.create((Component)Translation.message("tooltip.template_character", new Object[0])));
        this.addRenderableWidget((GuiEventListener)recordMenu);
        Button saveButton = Button.builder((Component)ImageFontConstants.SAVE, button -> {
            NarrativeCraftMod.server.execute(() -> this.cameraAngleController.stopSession(true));
            this.onClose();
        }).bounds(startX + (30 + spacing) * 3, y, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)saveButton);
        Button closeButton = Button.builder((Component)Component.literal((String)"\u2716"), button -> {
            ConfirmScreen confirm = new ConfirmScreen(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> this.cameraAngleController.stopSession(false));
                    this.onClose();
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.literal((String)""), (Component)Translation.message("controller.confirm_leaving", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
            this.minecraft.setScreen((Screen)confirm);
        }).bounds(startX + (30 + spacing) * 4, y, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }
}

