/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.mainScreen;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.cutscene.CutscenePlayback;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.data.MainScreenData;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.StorySave;
import fr.loudo.narrativecraft.narrative.story.StoryValidation;
import fr.loudo.narrativecraft.narrative.story.inkAction.FadeInkAction;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.screens.components.ChapterSelectorScreen;
import fr.loudo.narrativecraft.screens.components.CrashScreen;
import fr.loudo.narrativecraft.screens.components.FinishedStoryScreen;
import fr.loudo.narrativecraft.screens.components.NarrativeCraftLogoRenderer;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreenOptionsScreen;
import fr.loudo.narrativecraft.util.ErrorLine;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;

public class MainScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_IMAGE = ResourceLocation.withDefaultNamespace((String)"textures/narrativecraft_mainscreen/background.png");
    public static final ResourceLocation MUSIC = ResourceLocation.withDefaultNamespace((String)"narrativecraft_mainscreen.music");
    public static SimpleSoundInstance musicInstance = new SimpleSoundInstance(MUSIC, SoundSource.MASTER, 0.7f, 1.0f, SoundInstance.createUnseededRandom(), true, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    private final NarrativeCraftLogoRenderer narrativeCraftLogo = NarrativeCraftMod.getInstance().getNarrativeCraftLogoRenderer();
    private final PlayerSession playerSession;
    private final int buttonWidth = 100;
    private final int buttonHeight = 20;
    private final int initialX = 50;
    private final int gap = 5;
    private int initialY;
    private int showDevBtnCount;
    private Button devButton;
    private final boolean finishedStory;
    private final boolean pause;
    private boolean rendered;
    private int userFloodedKeyboard;

    public MainScreen(PlayerSession playerSession, boolean finishedStory, boolean pause) {
        super((Component)Component.literal((String)"Main screen"));
        this.finishedStory = finishedStory;
        this.pause = pause;
        this.playerSession = playerSession;
        this.userFloodedKeyboard = 0;
    }

    private void playStory() {
        this.onClose();
        StoryHandler storyHandler = new StoryHandler(this.playerSession);
        this.minecraft.getSoundManager().stop((SoundInstance)musicInstance);
        try {
            List<ErrorLine> errorLines = StoryValidation.validate();
            List<ErrorLine> warns = errorLines.stream().filter(ErrorLine::isWarn).toList();
            List<ErrorLine> errors = errorLines.stream().filter(errorLine -> !errorLine.isWarn()).toList();
            if (errors.isEmpty() && warns.isEmpty()) {
                NarrativeCraftMod.server.execute(storyHandler::start);
                return;
            }
            if (!warns.isEmpty()) {
                ConfirmScreen screen = new ConfirmScreen(t -> {
                    if (!t) {
                        this.minecraft.setScreen((Screen)this);
                        return;
                    }
                    this.minecraft.setScreen(null);
                    NarrativeCraftMod.server.execute(storyHandler::start);
                }, (Component)Component.empty(), (Component)Translation.message("screen.main_screen.no_error_but_warns", new Object[0]));
                this.minecraft.setScreen((Screen)screen);
            } else {
                CrashScreen crashScreen = new CrashScreen(this.playerSession, Translation.message("validation.from_main_screen", new Object[0]).getString());
                this.minecraft.setScreen((Screen)crashScreen);
            }
            NarrativeCraftMod.LOGGER.error(" ");
            NarrativeCraftMod.LOGGER.error("Story can't start: ");
            for (ErrorLine errorLine2 : errorLines) {
                NarrativeCraftMod.LOGGER.error("{} {} {}", new Object[]{errorLine2.getFileName(), errorLine2.getLineText(), errorLine2.getMessage()});
            }
            NarrativeCraftMod.LOGGER.error(" ");
        }
        catch (Exception e) {
            CrashScreen crashScreen = new CrashScreen(this.playerSession, e.getMessage());
            this.minecraft.setScreen((Screen)crashScreen);
        }
    }

    public void onClose() {
        super.onClose();
        if (!this.pause) {
            this.minecraft.getSoundManager().stop((SoundInstance)musicInstance);
            this.minecraft.options.hideGui = false;
            if (this.playerSession.getController() != null) {
                NarrativeCraftMod.server.execute(() -> this.playerSession.getController().stopSession(false));
            }
        }
    }

    protected void init() {
        int totalButtons;
        boolean firstGame;
        boolean storyFinished = NarrativeCraftMod.getInstance().getNarrativeWorldOption().finishedStory;
        this.minecraft.options.hideGui = true;
        this.showDevBtnCount = 0;
        StorySave save = null;
        try {
            save = NarrativeCraftFile.saveContent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = firstGame = save == null;
        if (!this.pause && this.playerSession.getController() == null) {
            try {
                MainScreenData mainScreenData = NarrativeCraftFile.getMainScreenBackground();
                MainScreenController mainScreenController = new MainScreenController(Environment.PRODUCTION, (Player)this.minecraft.player, mainScreenData);
                NarrativeCraftMod.server.execute(mainScreenController::startSession);
            }
            catch (Exception mainScreenData) {
                // empty catch block
            }
        }
        if (!this.pause && !this.rendered) {
            this.minecraft.getSoundManager().play((SoundInstance)musicInstance);
            this.rendered = true;
        }
        int n = totalButtons = storyFinished ? 5 : 4;
        if (this.pause) {
            totalButtons = 5;
        }
        if (!NarrativeCraftFile.saveExists()) {
            totalButtons = 3;
        }
        int totalHeight = 20 * totalButtons + 5 * (totalButtons - 1);
        this.initialY = this.height / 2 - totalHeight / 2;
        if (this.narrativeCraftLogo.logoExists()) {
            this.initialY += this.narrativeCraftLogo.getImageHeight() / 2 + 5;
        }
        int startY = this.initialY;
        MutableComponent playBtnComponent = firstGame && !this.pause ? Translation.message("screen.main_screen.play", new Object[0]) : Translation.message("screen.main_screen.continue", new Object[0]);
        boolean canPlay = !NarrativeCraftMod.getInstance().getChapterManager().getChapters().isEmpty();
        Button playButton = Button.builder((Component)playBtnComponent, button -> {
            if (this.pause) {
                this.onClose();
            } else {
                this.playStory();
            }
        }).bounds(50, startY, 100, 20).build();
        playButton.active = canPlay;
        if (!canPlay) {
            playButton.setTooltip(Tooltip.create((Component)Translation.message("screen.main_screen.cant_play_tooltip", new Object[0])));
        }
        this.addRenderableWidget((GuiEventListener)playButton);
        if (!firstGame && !this.pause) {
            Button startNewGame = Button.builder((Component)Translation.message("screen.main_screen.new_game", new Object[0]), button -> {
                ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                    if (b) {
                        NarrativeWorldOption option = NarrativeCraftMod.getInstance().getNarrativeWorldOption();
                        NarrativeCraftFile.removeSave();
                        option.finishedStory = false;
                        NarrativeCraftFile.updateWorldOptions(option);
                        this.playStory();
                    } else {
                        this.minecraft.setScreen((Screen)this);
                    }
                }, (Component)Component.literal((String)""), (Component)Translation.message("screen.main_screen.new_game.confirm", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
                this.minecraft.setScreen((Screen)confirmScreen);
            }).bounds(50, startY += 25, 100, 20).build();
            startNewGame.active = canPlay;
            if (!canPlay) {
                startNewGame.setTooltip(Tooltip.create((Component)Translation.message("screen.main_screen.cant_play_tooltip", new Object[0])));
            }
            this.addRenderableWidget((GuiEventListener)startNewGame);
        }
        if (!this.pause && NarrativeCraftMod.getInstance().getNarrativeWorldOption().finishedStory) {
            Button selectSceneButton = Button.builder((Component)Translation.message("screen.main_screen.select_screen", new Object[0]), button -> {
                this.minecraft.getSoundManager().stop((SoundInstance)musicInstance);
                ChapterSelectorScreen screen = new ChapterSelectorScreen(this.playerSession, this);
                this.minecraft.setScreen((Screen)screen);
            }).bounds(50, startY += 25, 100, 20).build();
            this.addRenderableWidget((GuiEventListener)selectSceneButton);
        }
        if (this.pause) {
            Button loadLastSaveButton = Button.builder((Component)(this.playerSession.getStoryHandler().isDebugMode() ? Translation.message("screen.main_screen.pause.restart_scene", new Object[0]) : Translation.message("screen.main_screen.pause.load_last_save", new Object[0])), button -> {
                StoryHandler storyHandler;
                this.minecraft.setScreen(null);
                if (this.playerSession.getStoryHandler().isDebugMode()) {
                    storyHandler = new StoryHandler(this.playerSession.getChapter(), this.playerSession.getScene(), this.playerSession);
                    storyHandler.setDebugMode(this.playerSession.getStoryHandler().isDebugMode());
                } else {
                    storyHandler = new StoryHandler(this.playerSession);
                }
                NarrativeCraftMod.server.execute(() -> {
                    this.playerSession.getStoryHandler().stop();
                    storyHandler.start();
                });
            }).bounds(50, startY += 25, 100, 20).build();
            this.addRenderableWidget((GuiEventListener)loadLastSaveButton);
            AbstractController controller = this.playerSession.getController();
            Button skipCutsceneButton = Button.builder((Component)Translation.message("screen.main_screen.pause.skip_cutscene", new Object[0]), button -> {
                CutsceneController cutsceneController;
                CutscenePlayback cutscenePlayback;
                this.minecraft.setScreen(null);
                if (controller instanceof CutsceneController && (cutscenePlayback = (cutsceneController = (CutsceneController)controller).getCutscenePlayback()) != null) {
                    this.playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof FadeInkAction);
                    NarrativeCraftMod.server.execute(cutsceneController::skip);
                    cutscenePlayback.stop();
                    CutsceneKeyframe keyframe = cutsceneController.getLastKeyframeLastGroup();
                    if (keyframe == null) {
                        return;
                    }
                    this.playerSession.setCurrentCamera(keyframe.getKeyframeLocation());
                }
            }).bounds(50, startY += 25, 100, 20).build();
            skipCutsceneButton.active = controller instanceof CutsceneController && controller != null;
            this.addRenderableWidget((GuiEventListener)skipCutsceneButton);
        }
        Button optionsButton = Button.builder((Component)Translation.message("screen.main_screen.options", new Object[0]), button -> {
            this.minecraft.getSoundManager().stop((SoundInstance)musicInstance);
            MainScreenOptionsScreen screen = new MainScreenOptionsScreen(this.playerSession, new MainScreen(this.playerSession, false, this.pause));
            this.minecraft.setScreen((Screen)screen);
        }).bounds(50, startY += 25, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)optionsButton);
        if (this.pause) {
            quitButton = Button.builder((Component)Translation.message("screen.main_screen.pause.leave", new Object[0]), button -> {
                boolean debugMod = this.playerSession.getStoryHandler().isDebugMode();
                NarrativeCraftMod.server.execute(() -> {
                    this.playerSession.getStoryHandler().stop();
                    if (NarrativeCraftMod.getInstance().getNarrativeWorldOption().showMainScreen && !debugMod) {
                        MainScreen mainScreen = new MainScreen(this.playerSession, false, false);
                        this.minecraft.execute(() -> this.minecraft.setScreen((Screen)mainScreen));
                    } else {
                        this.minecraft.execute(() -> this.minecraft.setScreen(null));
                    }
                });
            }).bounds(50, startY += 25, 100, 20).build();
            this.addRenderableWidget((GuiEventListener)quitButton);
        } else {
            quitButton = Button.builder((Component)Translation.message("screen.main_screen.quit", new Object[0]), button -> Util.disconnectPlayer()).bounds(50, startY += 25, 100, 20).build();
            this.addRenderableWidget((GuiEventListener)quitButton);
        }
        this.devButton = Button.builder((Component)Component.literal((String)"Dev Environment"), button -> {
            this.minecraft.player.displayClientMessage((Component)Translation.message("global.dev_env", new Object[0]), false);
            this.onClose();
        }).bounds(this.width - 100 - 10, 20, 100, 20).build();
        if (this.finishedStory) {
            FinishedStoryScreen screen = new FinishedStoryScreen(this.playerSession);
            this.minecraft.setScreen((Screen)screen);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.narrativeCraftLogo.logoExists()) {
            this.narrativeCraftLogo.render(guiGraphics, 50, this.initialY - this.narrativeCraftLogo.getImageHeight() - 5 - 5);
        }
        if (NarrativeCraftMod.getInstance().getChapterManager().getChapters().isEmpty() || this.userFloodedKeyboard > 20) {
            guiGraphics.drawString(this.minecraft.font, Translation.message("screen.main_screen.dev_tip", new Object[0]).getString(), guiGraphics.guiWidth() / 2 - this.minecraft.font.width((FormattedText)Translation.message("screen.main_screen.dev_tip", new Object[0])) / 2, 20, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.pause) {
            super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            return;
        }
        if (this.playerSession.getController() != null) {
            return;
        }
        if (Util.resourceExists(BACKGROUND_IMAGE)) {
            guiGraphics.blit(BACKGROUND_IMAGE, 0, 0, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        } else {
            guiGraphics.fill(0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), -16777216);
        }
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public boolean isPauseScreen() {
        return this.pause;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.pause) {
            ++this.userFloodedKeyboard;
        }
        if (keyCode == 341 && !this.pause) {
            ++this.showDevBtnCount;
            if (this.showDevBtnCount == 5) {
                this.addRenderableWidget((GuiEventListener)this.devButton);
            }
        }
        if (keyCode == 256 && !this.pause) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

