/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.options;

import com.mojang.authlib.GameProfile;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogEntityBobbing;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;

public class DialogCustomOptionsScreen
extends Screen {
    private final Screen lastScreen;
    private final PlayerSession playerSession;
    private final DialogData dialogData = new DialogData(DialogData.globalDialogData);
    private FakePlayer fakePlayer;
    private Vec3 lastPos;
    private float lastXRot;
    private float lastYRot;
    private ScreenUtils.LabelBox paddingXBox;
    private ScreenUtils.LabelBox paddingYBox;
    private ScreenUtils.LabelBox scaleBox;
    private ScreenUtils.LabelBox letterSpacingBox;
    private ScreenUtils.LabelBox gapBox;
    private ScreenUtils.LabelBox widthBox;
    private ScreenUtils.LabelBox bcColorBox;
    private ScreenUtils.LabelBox textColorBox;
    private ScreenUtils.LabelBox bobbingSpeed;
    private ScreenUtils.LabelBox bobbingStrength;
    private StringWidget errorWidget;

    public DialogCustomOptionsScreen(Screen lastScreen, PlayerSession playerSession) {
        super((Component)Component.literal((String)"Character Custom Dialog Screen"));
        this.lastScreen = lastScreen;
        this.playerSession = playerSession;
    }

    public void onClose() {
        LocalPlayer player = this.minecraft.player;
        player.setPos(this.lastPos);
        player.setXRot(this.lastXRot);
        player.setYRot(this.lastYRot);
        player.setYHeadRot(this.lastYRot);
        NarrativeCraftMod.server.execute(() -> {
            this.fakePlayer.remove(Entity.RemovalReason.KILLED);
            this.playerSession.getPlayer().connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.fakePlayer.getUUID())));
            this.playerSession.getPlayer().connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.fakePlayer.getId()}));
            this.playerSession.getPlayer().setGameMode(GameType.CREATIVE);
        });
        this.playerSession.setDialogRenderer(null);
        this.minecraft.setScreen(this.lastScreen);
        this.minecraft.options.hideGui = false;
    }

    protected void init() {
        this.minecraft.options.hideGui = true;
        if (this.fakePlayer == null) {
            Vec3 localPos;
            LocalPlayer player = this.minecraft.player;
            this.lastPos = localPos = player.position();
            this.lastXRot = player.getXRot();
            this.lastYRot = player.getYRot();
            this.minecraft.options.setCameraType(CameraType.FIRST_PERSON);
            player.setDeltaMovement(0.0, 0.0, 0.0);
            player.setPos(localPos.x, localPos.y + (double)player.getEyeHeight() + 5.0, localPos.z);
            player.setXRot(0.0f);
            player.setYRot(0.0f);
            player.setYHeadRot(0.0f);
            NarrativeCraftMod.server.execute(() -> {
                this.fakePlayer = new FakePlayer((ServerLevel)this.playerSession.getPlayer().level(), new GameProfile(UUID.randomUUID(), ""));
                this.fakePlayer.setXRot(0.0f);
                this.fakePlayer.setYHeadRot(180.0f);
                this.fakePlayer.setYRot(180.0f);
                this.fakePlayer.setPos(localPos.x, localPos.y + (double)player.getEyeHeight() + 4.2, localPos.z + 2.0);
                this.playerSession.getPlayer().connection.send((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)this.fakePlayer));
                this.playerSession.getPlayer().level().addFreshEntity((Entity)this.fakePlayer);
                this.playerSession.getPlayer().setGameMode(GameType.SPECTATOR);
                DialogRenderer3D dialog = new DialogRenderer3D("Lorem ipsum dolor sit amet consectetur adipiscing elit\n", "", this.dialogData, new CharacterRuntime(null, null, (LivingEntity)this.fakePlayer, this.playerSession.getScene()));
                dialog.setDialogEntityBobbing(new DialogEntityBobbing(dialog, this.dialogData.getNoiseShakeSpeed(), this.dialogData.getNoiseShakeStrength()));
                dialog.setNoSkip(true);
                dialog.start();
                this.playerSession.setDialogRenderer(dialog);
            });
        }
        int gap = 5;
        int labelHeight = 20;
        int labelWidth = 50;
        int startX = this.width - labelWidth - 120;
        this.errorWidget = ScreenUtils.text((Component)Component.literal((String)""), this.minecraft.font, this.width / 2, 10);
        this.addRenderableWidget((GuiEventListener)this.errorWidget);
        int currentY = this.height / 2 - (labelHeight + gap) * 12 / 2;
        this.paddingXBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Padding X"), this.minecraft.font, labelWidth, labelHeight, startX, currentY, ScreenUtils.Align.HORIZONTAL);
        this.paddingXBox.getEditBox().setValue(String.valueOf(this.dialogData.getPaddingX()));
        this.addRenderableWidget((GuiEventListener)this.paddingXBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.paddingXBox.getEditBox());
        this.paddingYBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Padding Y"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.paddingXBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.paddingYBox.getEditBox().setValue(String.valueOf(this.dialogData.getPaddingY()));
        this.addRenderableWidget((GuiEventListener)this.paddingYBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.paddingYBox.getEditBox());
        this.scaleBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Scale"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.paddingYBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.scaleBox.getEditBox().setValue(String.valueOf(this.dialogData.getScale()));
        this.addRenderableWidget((GuiEventListener)this.scaleBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.scaleBox.getEditBox());
        this.letterSpacingBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Letter Spacing"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.scaleBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.letterSpacingBox.getEditBox().setValue(String.valueOf(this.dialogData.getLetterSpacing()));
        this.addRenderableWidget((GuiEventListener)this.letterSpacingBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.letterSpacingBox.getEditBox());
        this.gapBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Gap"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.letterSpacingBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.gapBox.getEditBox().setValue(String.valueOf(this.dialogData.getGap()));
        this.addRenderableWidget((GuiEventListener)this.gapBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.gapBox.getEditBox());
        this.widthBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Width"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.gapBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.widthBox.getEditBox().setValue(String.valueOf(this.dialogData.getWidth()));
        this.addRenderableWidget((GuiEventListener)this.widthBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.widthBox.getEditBox());
        this.bcColorBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Background Color"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.widthBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.bcColorBox.getEditBox().setValue(Integer.toHexString(FastColor.ARGB32.color((int)0, (int)this.dialogData.getBackgroundColor())));
        this.addRenderableWidget((GuiEventListener)this.bcColorBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.bcColorBox.getEditBox());
        this.textColorBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Text Color"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.bcColorBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.textColorBox.getEditBox().setValue(Integer.toHexString(FastColor.ARGB32.color((int)0, (int)this.dialogData.getTextColor())));
        this.addRenderableWidget((GuiEventListener)this.textColorBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.textColorBox.getEditBox());
        this.bobbingSpeed = new ScreenUtils.LabelBox((Component)Component.literal((String)"Bobbing Speed"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.textColorBox.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.bobbingSpeed.getEditBox().setValue(String.valueOf(this.dialogData.getNoiseShakeSpeed()));
        this.addRenderableWidget((GuiEventListener)this.bobbingSpeed.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.bobbingSpeed.getEditBox());
        this.bobbingStrength = new ScreenUtils.LabelBox((Component)Component.literal((String)"Bobbing Strength"), this.minecraft.font, labelWidth, labelHeight, startX, currentY += this.bobbingSpeed.getEditBox().getHeight() + gap, ScreenUtils.Align.HORIZONTAL);
        this.bobbingStrength.getEditBox().setValue(String.valueOf(this.dialogData.getNoiseShakeStrength()));
        this.addRenderableWidget((GuiEventListener)this.bobbingStrength.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.bobbingStrength.getEditBox());
        Button updateButton = Button.builder((Component)Translation.message("global.update", new Object[0]), button -> this.updateValues()).pos(startX, currentY += this.bobbingStrength.getEditBox().getHeight() + gap).width(70).build();
        this.addRenderableWidget((GuiEventListener)updateButton);
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            try {
                this.updateValues();
                NarrativeCraftFile.updateGlobalDialogValues(this.dialogData);
                DialogData.globalDialogData = this.dialogData;
            }
            catch (IOException e) {
                Util.sendCrashMessage((Player)this.minecraft.player, e);
            }
            this.onClose();
        }).pos(updateButton.getX() + updateButton.getWidth() + 5, currentY).width(70).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        Button closeButton = Button.builder((Component)Translation.message("global.close", new Object[0]), button -> {
            this.updateValues();
            this.onClose();
        }).pos(startX, currentY += updateButton.getHeight() + gap).width(70).build();
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    private void updateValues() {
        try {
            this.dialogData.setPaddingX(Float.parseFloat(this.paddingXBox.getEditBox().getValue()));
            this.dialogData.setPaddingY(Float.parseFloat(this.paddingYBox.getEditBox().getValue()));
            this.dialogData.setScale(Float.parseFloat(this.scaleBox.getEditBox().getValue()));
            this.dialogData.setLetterSpacing(Float.parseFloat(this.letterSpacingBox.getEditBox().getValue()));
            this.dialogData.setGap(Float.parseFloat(this.gapBox.getEditBox().getValue()));
            this.dialogData.setWidth(Float.parseFloat(this.widthBox.getEditBox().getValue()));
            int backgroundColor = Integer.parseInt(this.bcColorBox.getEditBox().getValue(), 16);
            this.dialogData.setBackgroundColor(FastColor.ARGB32.color((int)255, (int)backgroundColor));
            this.dialogData.setTextColor(Integer.parseInt(this.textColorBox.getEditBox().getValue(), 16));
            this.dialogData.setNoiseShakeSpeed(Float.parseFloat(this.bobbingSpeed.getEditBox().getValue()));
            this.dialogData.setNoiseShakeStrength(Float.parseFloat(this.bobbingStrength.getEditBox().getValue()));
            DialogRenderer3D dialog = (DialogRenderer3D)this.playerSession.getDialogRenderer();
            dialog.setText(dialog.getText());
            dialog.setPaddingX(this.dialogData.getPaddingX());
            dialog.setPaddingY(this.dialogData.getPaddingY());
            dialog.setScale(this.dialogData.getScale());
            dialog.setLetterSpacing(this.dialogData.getLetterSpacing());
            dialog.setGap(this.dialogData.getGap());
            dialog.setWidth(this.dialogData.getWidth());
            dialog.setBackgroundColor(this.dialogData.getBackgroundColor());
            dialog.setTextColor(this.dialogData.getTextColor());
            dialog.getDialogEntityBobbing().setNoiseShakeSpeed(this.dialogData.getNoiseShakeSpeed());
            dialog.getDialogEntityBobbing().setNoiseShakeStrength(this.dialogData.getNoiseShakeStrength());
            dialog.update();
            this.errorWidget.setMessage((Component)Component.empty());
        }
        catch (NumberFormatException e) {
            MutableComponent message = Component.literal((String)e.getMessage()).withStyle(ChatFormatting.RED);
            this.errorWidget.setMessage((Component)message);
            this.errorWidget.setPosition(this.width / 2 - this.minecraft.font.width((FormattedText)message) / 2, 10);
            this.errorWidget.setWidth(this.minecraft.font.width((FormattedText)message));
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderBlurredBackground(float partialTick) {
    }
}

