/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.subscene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.PickElementScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.screens.storyManager.subscene.EditScreenSubsceneAdapter;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class SubscenesScreen
extends StoryElementScreen {
    private final Scene scene;

    public SubscenesScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.subscene_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Subscene> screen = new EditInfoScreen<Subscene>(this, null, new EditScreenSubsceneAdapter(this.scene));
            this.minecraft.setScreen(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(200).build());
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getSubscenes().stream().map(subscene -> {
            Button button = Button.builder((Component)Component.literal((String)subscene.getName()), button1 -> {}).build();
            button.active = false;
            List<Animation> availableAnimations = this.scene.getAnimations().stream().filter(anim -> subscene.getAnimations().stream().noneMatch(a -> a.getName().equals(anim.getName()))).toList();
            Button settingsButton = Button.builder((Component)ImageFontConstants.SETTINGS, b -> {
                PickElementScreen screen = new PickElementScreen(this, (Component)Translation.message("screen.pick.subscene.title", Translation.message("global.animations", new Object[0]), Component.literal((String)subscene.getName())), (Component)Translation.message("global.animations", new Object[0]), availableAnimations, subscene.getAnimations(), entries1 -> {
                    List<Animation> oldAnimations = subscene.getAnimations();
                    ArrayList<Animation> selected = new ArrayList<Animation>();
                    for (PickElementScreen.TransferableStorySelectionList.Entry entry : entries1) {
                        Animation a = (Animation)entry.getNarrativeEntry();
                        selected.add(a);
                    }
                    try {
                        subscene.getAnimations().clear();
                        subscene.getAnimations().addAll(selected);
                        NarrativeCraftFile.updateSubsceneFile(this.scene);
                        this.minecraft.setScreen((Screen)new SubscenesScreen(this.scene));
                    }
                    catch (Exception e) {
                        subscene.getAnimations().clear();
                        subscene.getAnimations().addAll(oldAnimations);
                        Util.sendCrashMessage((Player)this.minecraft.player, e);
                        this.minecraft.setScreen(null);
                    }
                });
                this.minecraft.setScreen((Screen)screen);
            }).width(20).build();
            settingsButton.setTooltip(Tooltip.create((Component)Translation.message("screen.story_manager.subscene_animation_link", new Object[0])));
            return new StoryElementList.StoryEntryData(button, List.of(settingsButton), () -> this.minecraft.setScreen(new EditInfoScreen<Subscene>(this, (Subscene)subscene, new EditScreenSubsceneAdapter(this.scene))), () -> {
                this.minecraft.setScreen((Screen)new SubscenesScreen(this.scene));
                try {
                    this.scene.removeSubscene((Subscene)subscene);
                    NarrativeCraftFile.updateSubsceneFile(this.scene);
                    this.minecraft.setScreen((Screen)new SubscenesScreen(this.scene));
                }
                catch (Exception e) {
                    this.scene.addSubscene((Subscene)subscene);
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                }
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.getSceneFolder(this.scene).toPath());
    }
}

