/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.scene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class EditScreenSceneAdapter
implements EditScreenAdapter<Scene> {
    private final Chapter chapter;

    public EditScreenSceneAdapter(Chapter chapter) {
        this.chapter = chapter;
    }

    @Override
    public void initExtraFields(EditInfoScreen<Scene> screen, Scene entry) {
        if (entry == null) {
            return;
        }
        class_5250 class_52502 = Translation.message("scene.rank", new Object[0]);
        class_327 class_3272 = screen.method_64506();
        Objects.requireNonNull(screen);
        ScreenUtils.LabelBox rankBox = new ScreenUtils.LabelBox((class_2561)class_52502, class_3272, 40, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
        rankBox.getEditBox().method_1890(string -> string.matches("^\\d*$"));
        rankBox.getEditBox().method_1852(String.valueOf(entry.getRank()));
        screen.extraFields.putIfAbsent("rank", rankBox);
        screen.extraFields.putIfAbsent("rankEditBox", rankBox.getEditBox());
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Scene> screen, Scene entry, int x, int y) {
        if (entry == null) {
            return;
        }
        ScreenUtils.LabelBox labelBox = (ScreenUtils.LabelBox)screen.extraFields.get("rank");
        labelBox.setPosition(x, y);
        screen.method_37063((Scene)labelBox.getStringWidget());
        screen.method_37063((Scene)labelBox.getEditBox());
    }

    @Override
    public void buildFromScreen(Map<String, Object> extraFields, class_310 minecraft, @Nullable Scene existing, String name, String description) {
        if (existing == null) {
            if (this.chapter.sceneExists(name)) {
                ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("scene.already_exists", name, this.chapter.getIndex()));
                return;
            }
            Scene scene = new Scene(name, description, this.chapter);
            try {
                NarrativeCraftFile.createSceneFolder(scene);
                this.chapter.addScene(scene);
                NarrativeCraftFile.updateInkIncludes();
                minecraft.method_1507((class_437)new ScenesScreen(this.chapter));
            }
            catch (Exception e) {
                this.chapter.removeScene(scene);
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        } else {
            Scene newScene = new Scene(name, description, this.chapter);
            Scene oldScene = new Scene(existing.getName(), existing.getDescription(), this.chapter);
            oldScene.setRank(existing.getRank());
            try {
                ScreenUtils.LabelBox labelBox = (ScreenUtils.LabelBox)extraFields.get("rank");
                class_342 editBox = labelBox.getEditBox();
                int rank = 1;
                if (!editBox.method_1882().isEmpty()) {
                    rank = Integer.parseInt(editBox.method_1882());
                }
                if (rank > this.chapter.getScenes().size()) {
                    ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("scene.rank_above_scenes_size", new Object[0]));
                    return;
                }
                if (rank < 1) {
                    ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("scene.rank_no_under_one", new Object[0]));
                    return;
                }
                newScene.setRank(rank);
                NarrativeCraftFile.updateSceneData(oldScene, newScene);
                existing.setName(name);
                existing.setDescription(description);
                this.chapter.setSceneRank(existing, rank);
                NarrativeCraftFile.updateInkIncludes();
                minecraft.method_1507((class_437)new ScenesScreen(this.chapter));
            }
            catch (Exception e) {
                existing.setName(oldScene.getName());
                existing.setDescription(oldScene.getDescription());
                this.chapter.setSceneRank(existing, oldScene.getRank());
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        }
    }
}

