/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.managers;

import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class PlaybackManager {
    public static final AtomicInteger ID_INCREMENTER = new AtomicInteger();
    private final List<Playback> playbacks = new ArrayList<Playback>();

    public List<Playback> getPlaybacksPlaying() {
        return this.playbacks.stream().filter(Playback::isPlaying).toList();
    }

    public List<Playback> getAnimationsByNamePlaying() {
        return this.playbacks;
    }

    public Playback createAndStart(Animation animation, Environment env, PlayerSession session) {
        Playback playback = new Playback(ID_INCREMENTER.incrementAndGet(), animation, (Level)session.getPlayer().level(), env, false);
        playback.start();
        this.addPlayback(playback);
        return playback;
    }

    public void addPlayback(Playback playback) {
        for (Playback playback1 : this.playbacks) {
            if (playback1.getId() != playback.getId()) continue;
            return;
        }
        this.playbacks.add(playback);
    }

    public void removePlayback(Playback playback) {
        this.playbacks.remove(playback);
    }

    public Playback getPlayback(int id) {
        for (Playback playback : this.playbacks) {
            if (playback.getId() != id) continue;
            return playback;
        }
        return null;
    }

    public Playback getPlayback(String animationName) {
        for (Playback playback : this.playbacks) {
            if (!playback.getAnimation().getName().equalsIgnoreCase(animationName)) continue;
            return playback;
        }
        return null;
    }

    public List<Playback> getAnimationsByNamePlaying(String animationName) {
        ArrayList<Playback> animationsPlaying = new ArrayList<Playback>();
        for (Playback playback : this.playbacks) {
            if (!playback.getAnimation().getName().equalsIgnoreCase(animationName)) continue;
            animationsPlaying.add(playback);
        }
        return animationsPlaying;
    }

    public boolean entityInPlayback(Entity entity) {
        for (Playback playback : this.playbacks) {
            if (!playback.entityInPlayback(entity)) continue;
            return true;
        }
        return false;
    }

    public List<Playback> getPlaybacks() {
        return this.playbacks;
    }

    public void stopAll() {
        for (Playback playback : this.playbacks) {
            playback.stop(true);
        }
        this.playbacks.clear();
    }
}

