/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.gui.ICustomGuiRender;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer2D;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.narrative.story.text.TextEffectAnimation;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Vector2f;

public class DialogScrollText {
    private final NarrativeClientOption clientOption = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
    private final DialogRenderer dialogRenderer;
    private final Minecraft minecraft;
    private final List<LetterLocation> lettersRenderer = new ArrayList<LetterLocation>();
    private TextEffectAnimation textEffectAnimation;
    private List<String> lines = new ArrayList<String>();
    private int currentLine;
    private int currentCharIndex;
    private float currentX;
    private float currentY;
    private float tickAccumulator = 0.0f;

    public DialogScrollText(DialogRenderer dialogRenderer, Minecraft minecraft) {
        this.dialogRenderer = dialogRenderer;
        this.minecraft = minecraft;
        ParsedDialog parsedDialog = ParsedDialog.parse(dialogRenderer.getText());
        this.setText(parsedDialog.cleanedText());
    }

    public void reset() {
        this.currentLine = 0;
        this.currentCharIndex = 0;
        this.tickAccumulator = 0.0f;
        float f = -this.dialogRenderer.getTotalHeight() + this.dialogRenderer.getPaddingY();
        Objects.requireNonNull(this.minecraft.font);
        this.currentY = f + 9.0f / 2.0f + this.dialogRenderer.getGap() / 2.0f + 0.7f;
        if (this.dialogRenderer instanceof DialogRenderer2D && this.lines.size() > 1) {
            Objects.requireNonNull(this.minecraft.font);
            this.currentY += (float)(9 * (this.lines.size() - 1)) / 2.0f;
        }
        this.currentX = -this.dialogRenderer.getTotalWidth() + this.dialogRenderer.getPaddingX() * 2.0f;
        this.lettersRenderer.clear();
        this.textEffectAnimation = new TextEffectAnimation(this.dialogRenderer.getText());
    }

    public void forceFinish() {
        while (!this.isFinished()) {
            this.addLetter();
        }
    }

    public void tick() {
        if (!this.isFinished() && !this.dialogRenderer.isAnimating()) {
            this.tickAccumulator += 1.0f;
            this.populateLetters();
        }
        this.textEffectAnimation.tick();
    }

    public void render(PoseStack poseStack, MultiBufferSource.BufferSource source, float partialTick) {
        Map<Integer, Vector2f> offsets = this.textEffectAnimation.getOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            LetterLocation letter = this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x;
            float y = letter.y;
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            this.minecraft.font.drawInBatch(String.valueOf(letter.letter), x, y, ARGB.color((int)255, (int)this.dialogRenderer.getTextColor()), false, poseStack.last().pose(), (MultiBufferSource)this.minecraft.renderBuffers().bufferSource(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        }
        source.endBatch();
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        Map<Integer, Vector2f> offsets = this.textEffectAnimation.getOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            LetterLocation letter = this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x;
            float y = letter.y;
            DialogRenderer dialogRenderer = this.dialogRenderer;
            if (dialogRenderer instanceof DialogRenderer3D) {
                DialogRenderer3D dialogRenderer3D = (DialogRenderer3D)dialogRenderer;
                if (dialogRenderer3D.getDialogOffset().y < 0.0f) {
                    y += dialogRenderer3D.getTotalHeight() - dialogRenderer3D.getPaddingY();
                }
            }
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            ((ICustomGuiRender)guiGraphics).narrativecraft$drawStringFloat(String.valueOf(letter.letter), this.minecraft.font, x, y, ARGB.color((int)255, (int)this.dialogRenderer.getTextColor()), false);
        }
    }

    public boolean isFinished() {
        return this.currentLine == this.lines.size() - 1 && this.currentCharIndex == this.lines.getLast().length();
    }

    public String getLongerTextLine() {
        return this.lines.stream().max(Comparator.comparingInt(String::length)).orElse("");
    }

    public void setText(String text) {
        this.lines = this.splitText(text);
    }

    private List<String> splitText(String text) {
        ArrayList<String> finalString = new ArrayList<String>();
        Minecraft client = Minecraft.getInstance();
        List charSequences = client.font.split(FormattedText.of((String)text), (int)this.dialogRenderer.getWidth());
        for (FormattedCharSequence chara : charSequences) {
            StringBuilder stringBuilder = new StringBuilder();
            chara.accept((i, style, i1) -> {
                stringBuilder.appendCodePoint(i1);
                return true;
            });
            finalString.add(stringBuilder.toString());
        }
        return finalString;
    }

    private void populateLetters() {
        boolean playSound = false;
        while (this.tickAccumulator >= (float)this.currentLine && this.currentLine < this.lines.size()) {
            if (this.addLetter() != ' ') {
                playSound = true;
            }
            this.tickAccumulator -= this.clientOption.textSpeed;
        }
        if (playSound) {
            this.playLetterSound();
        }
    }

    private char addLetter() {
        if (this.currentLine >= this.lines.size()) {
            return ' ';
        }
        String currentLineText = this.lines.get(this.currentLine);
        if (currentLineText.isEmpty() || this.currentCharIndex >= currentLineText.length()) {
            if (this.lines.size() > 1 && this.currentLine < this.lines.size() - 1) {
                this.moveToNextLine();
            }
            return ' ';
        }
        char letter = currentLineText.charAt(this.currentCharIndex);
        this.lettersRenderer.add(new LetterLocation(letter, this.currentX, this.currentY, true));
        this.currentX += Util.getLetterWidth(letter, this.minecraft) + this.dialogRenderer.getLetterSpacing();
        ++this.currentCharIndex;
        if (this.currentCharIndex >= currentLineText.length() && this.lines.size() > 1 && this.currentLine < this.lines.size() - 1) {
            this.moveToNextLine();
        }
        return letter;
    }

    private void moveToNextLine() {
        this.lettersRenderer.add(new LetterLocation(' ', this.currentX, this.currentY, false));
        ++this.currentLine;
        this.currentCharIndex = 0;
        this.currentX = -this.dialogRenderer.getTotalWidth() + this.dialogRenderer.getPaddingX() * 2.0f;
        Objects.requireNonNull(this.minecraft.font);
        this.currentY += 9.0f + this.dialogRenderer.getGap();
    }

    private void playLetterSound() {
        float pitch = 0.8f + new Random().nextFloat() * 0.4f;
        ResourceLocation soundRes = ResourceLocation.withDefaultNamespace((String)"sfx.dialog_sound");
        SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)soundRes);
        this.minecraft.player.playSound(soundEvent, 1.0f, pitch);
    }

    public List<String> getLines() {
        return this.lines;
    }

    private record LetterLocation(char letter, float x, float y, boolean render) {
    }
}

