/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class CutsceneInkAction
extends InkAction {
    private Cutscene cutscene;
    private CutsceneController controller;

    public CutsceneInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (!this.isRunning) {
            return;
        }
        if (this.controller.atMaxTick()) {
            this.blockEndTask.run();
        }
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() < 3) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Cutscene name"));
        }
        String cutsceneName = arguments.get(2);
        this.cutscene = scene.getCutsceneByName(cutsceneName);
        if (this.cutscene == null) {
            return InkActionResult.error((Component)Translation.message("cutscene.no_exists", cutsceneName, scene.getName()));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        this.controller = new CutsceneController(Environment.PRODUCTION, (Player)playerSession.getPlayer(), this.cutscene);
        this.controller.startSession();
        if (this.controller.getKeyframeGroups().isEmpty()) {
            return InkActionResult.error("Cutscene " + this.cutscene.getName() + " has not keyframes ! Can't be played.");
        }
        CutsceneKeyframeGroup keyframeGroup = (CutsceneKeyframeGroup)this.controller.getKeyframeGroups().getFirst();
        CutsceneKeyframe keyframeA = (CutsceneKeyframe)keyframeGroup.getKeyframes().getFirst();
        CutsceneKeyframe keyframeB = keyframeGroup.getKeyframes().size() > 1 ? (CutsceneKeyframe)keyframeGroup.getKeyframes().get(1) : keyframeA;
        this.controller.setPlaying(true);
        this.controller.getCutscenePlayback().setupAndPlay(keyframeA, keyframeB);
        return InkActionResult.block();
    }

    @Override
    public boolean needScene() {
        return true;
    }
}

