/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class AbstractTextBoxScreen
extends Screen {
    private static final ResourceLocation WINDOW_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/window.png");
    protected final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

    protected AbstractTextBoxScreen(Component title) {
        super(title);
    }

    protected void init() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(4));
        linearLayout.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"Done"), button -> this.onClose()).width(130).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int i = (this.width - 252) / 2;
        int j = (this.height - 140) / 2;
        this.renderInsideBox(guiGraphics, i, j);
        this.renderWindow(guiGraphics, i, j);
    }

    private void renderInsideBox(GuiGraphics guiGraphics, int offsetX, int offsetY) {
        int startY;
        int boxX = offsetX + 9;
        int boxY = offsetY + 18;
        int boxWidth = 234;
        int boxHeight = 113;
        int centerX = boxX + boxWidth / 2;
        guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -16777216);
        List<String> lines = this.renderContent();
        ArrayList sequences = new ArrayList();
        for (String line : lines) {
            List splits = this.minecraft.font.split(FormattedText.of((String)line), 200);
            sequences.addAll(splits);
        }
        int n = sequences.size();
        Objects.requireNonNull(this.minecraft.font);
        int totalTextHeight = n * 9;
        int currentY = startY = boxY + (boxHeight - totalTextHeight) / 2;
        for (FormattedCharSequence line : sequences) {
            guiGraphics.drawCenteredString(this.font, line, centerX, currentY, -1);
            Objects.requireNonNull(this.minecraft.font);
            currentY += 9;
        }
    }

    public void renderWindow(GuiGraphics guiGraphics, int offsetX, int offsetY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WINDOW_LOCATION, offsetX, offsetY, 0.0f, 0.0f, 252, 140, 256, 256);
    }

    protected abstract List<String> renderContent();
}

