/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cameraAngle;

import fr.loudo.narrativecraft.controllers.cameraAngle.CameraAngleController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.EntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.ItemChangeAction;
import fr.loudo.narrativecraft.narrative.recording.actions.LivingEntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PoseAction;
import fr.loudo.narrativecraft.screens.components.ButtonListScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CameraAngleAddTemplateCharacter
extends ButtonListScreen {
    private final CameraAngleController cameraAngleController;
    private List<Button> buttons = new ArrayList<Button>();

    public CameraAngleAddTemplateCharacter(Screen lastScreen, CameraAngleController cameraAngleController) {
        super(lastScreen, (Component)Translation.message("controller.camera_angle.template_character", cameraAngleController.getCameraAngle().getName()));
        this.cameraAngleController = cameraAngleController;
    }

    public CameraAngleAddTemplateCharacter(Screen lastScreen, Component title, CameraAngleController cameraAngleController, List<Button> buttons) {
        super(lastScreen, title);
        this.cameraAngleController = cameraAngleController;
        this.buttons = buttons;
    }

    @Override
    protected void addContents() {
        this.objectListScreen.clear();
        Scene scene = this.cameraAngleController.getCameraAngle().getScene();
        if (!this.buttons.isEmpty()) {
            for (Button button2 : this.buttons) {
                this.objectListScreen.addButton((AbstractWidget)button2);
            }
            return;
        }
        ArrayList animationsButton = new ArrayList();
        Button animationButton = Button.builder((Component)Translation.message("global.animations", new Object[0]), button -> {
            for (Animation animation : scene.getAnimations()) {
                Button button1 = Button.builder((Component)Component.literal((String)animation.getName()), button2 -> this.spawnEntity(animation, animation.getActionsData().getFirst().getLocations().size() - 1)).build();
                animationsButton.add(button1);
            }
            this.minecraft.setScreen((Screen)new CameraAngleAddTemplateCharacter(this, (Component)Translation.message("global.animations", new Object[0]), this.cameraAngleController, animationsButton));
        }).build();
        this.objectListScreen.addButton((AbstractWidget)animationButton);
        ArrayList subscenesButton = new ArrayList();
        Button subsceneButton = Button.builder((Component)Translation.message("global.subscenes", new Object[0]), button -> {
            for (Subscene subscene : scene.getSubscenes()) {
                Button button1 = Button.builder((Component)Component.literal((String)subscene.getName()), button2 -> {
                    for (Animation animation : subscene.getAnimations()) {
                        this.spawnEntity(animation, animation.getActionsData().getFirst().getLocations().size() - 1);
                    }
                }).build();
                subscenesButton.add(button1);
            }
            this.minecraft.setScreen((Screen)new CameraAngleAddTemplateCharacter(this, (Component)Translation.message("global.subscenes", new Object[0]), this.cameraAngleController, subscenesButton));
        }).build();
        this.objectListScreen.addButton((AbstractWidget)subsceneButton);
        ArrayList cutscenesButton = new ArrayList();
        Button cutsceneButton = Button.builder((Component)Translation.message("global.cutscenes", new Object[0]), button -> {
            for (Cutscene cutscene : scene.getCutscenes()) {
                if (cutscene.getKeyframeGroups().isEmpty()) continue;
                Button button1 = Button.builder((Component)Component.literal((String)cutscene.getName()), button2 -> {
                    CutsceneKeyframe lastKeyframe = (CutsceneKeyframe)cutscene.getKeyframeGroups().getLast().getKeyframes().getLast();
                    int lastLocIndex = lastKeyframe.getTick() + 2 + lastKeyframe.getTransitionDelayTick();
                    for (Subscene subscene : cutscene.getSubscenes()) {
                        for (Animation animation : subscene.getAnimations()) {
                            this.spawnEntity(animation, Math.min(lastLocIndex, animation.getActionsData().getFirst().getLocations().size() - 1));
                        }
                    }
                    for (Animation animation : cutscene.getAnimations()) {
                        this.spawnEntity(animation, Math.min(lastLocIndex, animation.getActionsData().getFirst().getLocations().size() - 1));
                    }
                }).build();
                cutscenesButton.add(button1);
            }
            this.minecraft.setScreen((Screen)new CameraAngleAddTemplateCharacter(this, (Component)Translation.message("global.cutscenes", new Object[0]), this.cameraAngleController, cutscenesButton));
        }).build();
        this.objectListScreen.addButton((AbstractWidget)cutsceneButton);
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(200).build());
    }

    private void spawnEntity(Animation animation, int index) {
        List<Action> actions = animation.getActionsData().getFirst().getActions().stream().filter(action -> index >= action.getTick() && (action instanceof ItemChangeAction || action instanceof LivingEntityByteAction || action instanceof EntityByteAction || action instanceof PoseAction)).toList();
        CharacterStoryData characterStoryData = new CharacterStoryData(animation.getCharacter(), animation.getLastLocation(), true);
        characterStoryData.spawn((Level)this.cameraAngleController.getPlayerSession().getPlayer().level(), Environment.DEVELOPMENT);
        PlaybackData playbackData = new PlaybackData(animation.getActionsData().getFirst(), null);
        playbackData.setEntity((Entity)characterStoryData.getCharacterRuntime().getEntity());
        for (Action action2 : actions) {
            action2.execute(playbackData);
        }
        characterStoryData.applyItems(this.minecraft.player.registryAccess());
        characterStoryData.applyBytes((LivingEntity)playbackData.getEntity());
        this.cameraAngleController.getCharacterStoryDataList().add(characterStoryData);
        this.cameraAngleController.getPlayerSession().getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
        this.minecraft.setScreen(null);
    }
}

