/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneSettingsScreen;
import fr.loudo.narrativecraft.screens.keyframe.KeyframeTriggerScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class CutsceneControllerScreen
extends Screen {
    private final Component pauseText = Component.literal((String)"\u23f8");
    private final Component playText = Component.literal((String)"\u25b6");
    private final int BUTTON_HEIGHT = 20;
    private int initialY;
    private int totalWidthControllerBtn;
    private Button controllerButton;
    private final CutsceneController cutsceneController;

    public CutsceneControllerScreen(CutsceneController cutsceneController) {
        super((Component)Component.literal((String)"Cutscene Controller Screen"));
        this.cutsceneController = cutsceneController;
    }

    protected void init() {
        this.initialY = this.height - 80;
        this.initControllerButtons();
        this.initKeyframesButton();
        this.initSettingsButton();
    }

    private void initControllerButtons() {
        int pauseBtnWidth = 20;
        int btnWidth = 50;
        int gap = 5;
        this.totalWidthControllerBtn = pauseBtnWidth + btnWidth * 2 + gap * 2;
        int startX = (this.width - this.totalWidthControllerBtn) / 2;
        String previousText = "- %.1fs";
        Button previousSkip = Button.builder((Component)Component.literal((String)String.format(previousText, (double)this.cutsceneController.getSkipTickCount() / 20.0)), button -> this.cutsceneController.previousSecondSkip()).bounds(startX, this.initialY, btnWidth, 20).build();
        this.controllerButton = Button.builder((Component)(this.cutsceneController.isPlaying() ? this.pauseText : this.playText), button -> this.playOrPause()).bounds(startX + btnWidth + gap, this.initialY, pauseBtnWidth, 20).build();
        String nextText = "+ %.1fs";
        Button nextSkip = Button.builder((Component)Component.literal((String)String.format(nextText, (double)this.cutsceneController.getSkipTickCount() / 20.0)), button -> this.cutsceneController.nextSecondSkip()).bounds(startX + btnWidth + gap + pauseBtnWidth + gap, this.initialY, btnWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)previousSkip);
        this.addRenderableWidget((GuiEventListener)this.controllerButton);
        this.addRenderableWidget((GuiEventListener)nextSkip);
    }

    private void initKeyframesButton() {
        int btnWidth = 30;
        int gap = 5;
        int totalWidth = btnWidth * 3 + gap * 2 + 15;
        int controllerStartX = (this.width - this.totalWidthControllerBtn) / 2;
        int startX = controllerStartX - gap - totalWidth;
        Button createKeyframeGroup = Button.builder((Component)ImageFontConstants.CREATE_KEYFRAME_GROUP, button -> {
            CutsceneKeyframeGroup keyframeGroup = this.cutsceneController.createKeyframeGroup();
            this.minecraft.player.displayClientMessage((Component)Translation.message("controller.cutscene.keyframe_group_created", keyframeGroup.getId()), false);
        }).bounds(startX, this.initialY, btnWidth, 20).build();
        createKeyframeGroup.setTooltip(Tooltip.create((Component)Translation.message("tooltip.create_keyframe_group", new Object[0])));
        Button addKeyframe = Button.builder((Component)ImageFontConstants.ADD_KEYFRAME, button -> this.cutsceneController.createKeyframe()).bounds(startX + btnWidth + gap, this.initialY, btnWidth, 20).build();
        addKeyframe.setTooltip(Tooltip.create((Component)Translation.message("tooltip.create_keyframe", new Object[0])));
        Button addTriggerKeyframe = Button.builder((Component)ImageFontConstants.ADD_KEYFRAME_TRIGGER, button -> {
            KeyframeTriggerScreen screen = new KeyframeTriggerScreen((AbstractKeyframeController<? extends Keyframe>)this.cutsceneController, this.cutsceneController.getCurrentTick());
            this.minecraft.setScreen((Screen)screen);
        }).bounds(startX + (btnWidth + gap) * 2, this.initialY, btnWidth, 20).build();
        addTriggerKeyframe.setTooltip(Tooltip.create((Component)Translation.message("tooltip.create_keyframe_trigger", new Object[0])));
        this.addRenderableWidget((GuiEventListener)createKeyframeGroup);
        this.addRenderableWidget((GuiEventListener)addKeyframe);
        this.addRenderableWidget((GuiEventListener)addTriggerKeyframe);
    }

    private void initSettingsButton() {
        int btnWidth = 30;
        int controllerStartX = (this.width - this.totalWidthControllerBtn) / 2;
        int startX = controllerStartX + this.totalWidthControllerBtn + 15;
        Button settingsButton = Button.builder((Component)ImageFontConstants.SETTINGS, button -> this.minecraft.setScreen((Screen)new CutsceneSettingsScreen(this.cutsceneController, this, (Component)Translation.message("controller.cutscene.settings.screen_name", new Object[0])))).bounds(startX, this.initialY, btnWidth, 20).build();
        settingsButton.setTooltip(Tooltip.create((Component)Translation.message("tooltip.cutscene_settings", new Object[0])));
        this.addRenderableWidget((GuiEventListener)settingsButton);
        startX = settingsButton.getX() + settingsButton.getWidth() + 5;
        Button saveButton = Button.builder((Component)ImageFontConstants.SAVE, button -> {
            NarrativeCraftMod.server.execute(() -> this.cutsceneController.stopSession(true));
            this.onClose();
        }).bounds(startX, this.initialY, btnWidth, 20).build();
        saveButton.setTooltip(Tooltip.create((Component)Translation.message("tooltip.save", new Object[0])));
        this.addRenderableWidget((GuiEventListener)saveButton);
        startX = saveButton.getX() + saveButton.getWidth() + 5;
        Button closeButton = Button.builder((Component)Component.literal((String)"\u2716"), button -> {
            ConfirmScreen confirm = new ConfirmScreen(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> this.cutsceneController.stopSession(false));
                    this.onClose();
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.literal((String)""), (Component)Translation.message("controller.confirm_leaving", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
            this.minecraft.setScreen((Screen)confirm);
        }).bounds(startX, this.initialY, btnWidth, 20).build();
        closeButton.setTooltip(Tooltip.create((Component)Translation.message("tooltip.leave_without_saving", new Object[0])));
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    private void playOrPause() {
        if (this.cutsceneController.isPlaying()) {
            this.cutsceneController.pause();
            this.controllerButton.setMessage(this.playText);
        } else {
            if (this.cutsceneController.atMaxTick()) {
                return;
            }
            this.cutsceneController.resume();
            this.controllerButton.setMessage(this.pauseText);
        }
    }

    protected void renderBlurredBackground(GuiGraphics guiGraphics) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public Button getControllerButton() {
        return this.controllerButton;
    }

    public Component getPauseText() {
        return this.pauseText;
    }

    public Component getPlayText() {
        return this.playText;
    }
}

