/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.cutscene.CutscenePlayback;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.KeyframeOptionScreen;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneKeyframeAdvancedSettings;
import fr.loudo.narrativecraft.util.MathHelper;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CutsceneKeyframeOptionScreen
extends KeyframeOptionScreen<CutsceneKeyframe, CutsceneController> {
    private final CutsceneController cutsceneController;
    private final CutsceneKeyframeGroup cutsceneKeyframeGroup;
    private EditBox startDelayBox;
    private EditBox pathTimeBox;
    private EditBox transitionDelayBox;
    private EditBox speedBox;

    public CutsceneKeyframeOptionScreen(CutsceneKeyframe keyframe, PlayerSession playerSession, boolean hide) {
        super(keyframe, (CutsceneController)playerSession.getController(), playerSession, hide);
        this.cutsceneController = (CutsceneController)playerSession.getController();
        this.cutsceneKeyframeGroup = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(keyframe);
        this.reloadScreen = () -> this.minecraft.setScreen((Screen)new CutsceneKeyframeOptionScreen(keyframe, playerSession, false));
    }

    @Override
    protected void init() {
        if (!this.hide) {
            if (!((CutsceneKeyframe)this.keyframe).isParentGroup()) {
                this.pathTimeBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.path_time", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getPathTick())));
                this.speedBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.speed", new Object[0]), String.valueOf(((CutsceneKeyframe)this.keyframe).getSpeed()));
            }
            if (this.cutsceneKeyframeGroup.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
                this.transitionDelayBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.transition_delay", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getTransitionDelayTick())));
            } else {
                this.startDelayBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.start_delay", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getStartDelayTick())));
            }
            this.initPositionLabelBox();
            this.initSliders();
            this.initButtons();
            this.initTextSelectedKeyframe();
        }
        this.initLittleButtons();
        this.currentY = 15;
    }

    public void onClose() {
    }

    @Override
    protected void initButtons() {
        int gap = 15;
        int margin = 15;
        MutableComponent updateTitle = Translation.message("screen.keyframe_option.update", new Object[0]);
        Button updateButton = Button.builder((Component)updateTitle, button -> {
            this.updateValues();
            this.cutsceneController.updateCurrentTick(((CutsceneKeyframe)this.keyframe).getTick());
            this.cutsceneController.changeTimePosition(((CutsceneKeyframe)this.keyframe).getTick(), true);
        }).bounds(20, this.currentY, this.font.width((FormattedText)updateTitle) + margin, 20).build();
        MutableComponent playTitle = Translation.message("screen.keyframe_option.play_from_here", new Object[0]);
        Button playFromHere = Button.builder((Component)playTitle, button -> {
            if (this.playerSession != null) {
                CutscenePlayback cutscenePlayback = this.cutsceneController.getCutscenePlayback();
                if (this.cutsceneKeyframeGroup.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
                    if (this.cutsceneKeyframeGroup.getKeyframes().size() > 1) {
                        CutsceneKeyframe previous = this.cutsceneController.getPreviousKeyframe((CutsceneKeyframe)this.keyframe);
                        cutscenePlayback.setupAndPlay(previous, (CutsceneKeyframe)this.keyframe);
                        int offset = ((CutsceneKeyframe)this.keyframe).getTick() - previous.getTick();
                        cutscenePlayback.setSegmentTick(offset);
                        cutscenePlayback.setTotalTick(previous.getTick() + offset);
                    } else {
                        cutscenePlayback.setupAndPlay((CutsceneKeyframe)this.keyframe, (CutsceneKeyframe)this.keyframe);
                    }
                } else {
                    cutscenePlayback.setupAndPlay((CutsceneKeyframe)this.keyframe, this.cutsceneController.getNextKeyframe((CutsceneKeyframe)this.keyframe));
                }
                NarrativeCraftMod.server.execute(() -> this.cutsceneController.setPlaying(true));
                this.minecraft.setScreen(null);
            }
        }).bounds(updateButton.getWidth() + updateButton.getX() + 5, this.currentY, this.font.width((FormattedText)playTitle) + margin, 20).build();
        this.currentY += 20 + gap - 10;
        MutableComponent advancedTitle = Translation.message("screen.keyframe_option.advanced", new Object[0]);
        Button advancedButton = Button.builder((Component)advancedTitle, button -> {
            CutsceneKeyframeAdvancedSettings screen = new CutsceneKeyframeAdvancedSettings((Screen)this, (CutsceneKeyframe)this.keyframe);
            this.minecraft.setScreen((Screen)screen);
        }).bounds(20, this.currentY, this.font.width((FormattedText)advancedTitle) + margin, 20).build();
        this.currentY += 20 + gap;
        MutableComponent removeTitle = Translation.message("global.remove", new Object[0]);
        Button removeKeyframe = Button.builder((Component)removeTitle, button -> {
            ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                if (b) {
                    if (this.playerSession != null) {
                        this.cutsceneController.setCamera(null);
                        this.cutsceneController.removeKeyframe((CutsceneKeyframe)this.keyframe);
                        this.cutsceneController.updateCurrentTick(((CutsceneKeyframe)this.keyframe).getTick());
                        this.minecraft.setScreen(null);
                    }
                } else {
                    CutsceneKeyframeOptionScreen screen = new CutsceneKeyframeOptionScreen((CutsceneKeyframe)this.keyframe, this.playerSession, false);
                    this.minecraft.setScreen((Screen)screen);
                }
            }, (Component)Component.literal((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
            this.minecraft.setScreen((Screen)confirmScreen);
        }).bounds(20, this.currentY, this.font.width((FormattedText)removeTitle) + margin, 20).build();
        this.addRenderableWidget((GuiEventListener)updateButton);
        this.addRenderableWidget((GuiEventListener)advancedButton);
        if (!this.cutsceneController.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
            this.addRenderableWidget((GuiEventListener)playFromHere);
        }
        this.addRenderableWidget((GuiEventListener)removeKeyframe);
    }

    @Override
    protected void initTextSelectedKeyframe() {
        int y = 10;
        MutableComponent groupText = Translation.message("screen.keyframe_option.keyframe_group", this.cutsceneKeyframeGroup.getId());
        MutableComponent keyframeText = Translation.message("screen.keyframe_option.keyframe_id", ((CutsceneKeyframe)this.keyframe).getId());
        int groupWidth = this.font.width((FormattedText)groupText);
        int keyframeWidth = this.font.width((FormattedText)keyframeText);
        int spacing = 5;
        int totalWidth = groupWidth + spacing + keyframeWidth;
        int startX = (this.width - totalWidth) / 2;
        StringWidget groupLabel = ScreenUtils.text((Component)groupText, this.font, startX, y, 2608927);
        StringWidget keyframeIdLabel = ScreenUtils.text((Component)keyframeText, this.font, startX + groupWidth + spacing, y, 15844367);
        this.addRenderableWidget((GuiEventListener)groupLabel);
        this.addRenderableWidget((GuiEventListener)keyframeIdLabel);
    }

    @Override
    protected void updateValues() {
        if (this.startDelayBox != null) {
            try {
                float startDelayVal = Float.parseFloat(this.startDelayBox.getValue());
                ((CutsceneKeyframe)this.keyframe).setStartDelayTick(MathHelper.secondsToTick(startDelayVal));
            }
            catch (NumberFormatException startDelayVal) {
                // empty catch block
            }
        }
        if (this.transitionDelayBox != null) {
            try {
                float transitionDelayValue = Float.parseFloat(this.transitionDelayBox.getValue());
                ((CutsceneKeyframe)this.keyframe).setTransitionDelayTick(MathHelper.secondsToTick(transitionDelayValue));
            }
            catch (NumberFormatException transitionDelayValue) {
                // empty catch block
            }
        }
        if (this.speedBox != null) {
            try {
                double speedValue = Double.parseDouble(this.speedBox.getValue());
                ((CutsceneKeyframe)this.keyframe).setSpeed(speedValue);
            }
            catch (NumberFormatException speedValue) {
                // empty catch block
            }
        }
        try {
            float pathTimeVal = this.pathTimeBox == null ? 0.0f : Float.parseFloat(this.pathTimeBox.getValue());
            ((CutsceneKeyframe)this.keyframe).setPathTick(MathHelper.secondsToTick(pathTimeVal));
        }
        catch (NumberFormatException pathTimeVal) {
            // empty catch block
        }
        KeyframeLocation location = this.getKeyframeLocation();
        ((CutsceneKeyframe)this.keyframe).setKeyframeLocation(location);
        ((CutsceneKeyframe)this.keyframe).updateEntityData(this.player);
    }

    private KeyframeLocation getKeyframeLocation() {
        KeyframeLocation location = ((CutsceneKeyframe)this.keyframe).getKeyframeLocation();
        location.setPitch(this.upDownValue);
        location.setYaw(this.leftRightValue);
        location.setRoll(this.rotationValue);
        try {
            float xVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(0)).getValue());
            float yVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(1)).getValue());
            float zVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(2)).getValue());
            location.setX(xVal);
            location.setY(yVal);
            location.setZ(zVal);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        location.setFov(this.fovValue);
        return location;
    }
}

