/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.mainScreen;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.screens.keyframe.KeyframeTriggerScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MainScreenControllerScreen
extends Screen {
    private final int BUTTON_HEIGHT = 20;
    private final int BUTTON_WIDTH = 30;
    private final MainScreenController mainScreenController;

    public MainScreenControllerScreen(MainScreenController mainScreenController) {
        super((Component)Component.literal((String)"Main Screen Controller Screen"));
        this.mainScreenController = mainScreenController;
    }

    protected void init() {
        int spacing = 5;
        int totalWidth = 150 + spacing * 3;
        int startX = (this.width - totalWidth) / 2;
        int y = this.height - 50;
        Button addKeyframe = Button.builder((Component)ImageFontConstants.ADD_KEYFRAME, button -> {
            if (this.mainScreenController.getKeyframe() == null) {
                this.mainScreenController.addKeyframe();
            } else {
                this.minecraft.player.displayClientMessage((Component)Translation.message("controller.main_screen.only_one_keyframe", new Object[0]).withStyle(ChatFormatting.RED), false);
            }
        }).bounds(startX, y, 30, 20).build();
        addKeyframe.setTooltip(Tooltip.create((Component)Translation.message("tooltip.create_keyframe", new Object[0])));
        this.addRenderableWidget((GuiEventListener)addKeyframe);
        Button addKeyframeTrigger = Button.builder((Component)ImageFontConstants.ADD_KEYFRAME_TRIGGER, button -> {
            if (this.mainScreenController.getKeyframeTrigger() == null) {
                KeyframeTriggerScreen screen = new KeyframeTriggerScreen((AbstractKeyframeController<? extends Keyframe>)this.mainScreenController, 0);
                this.minecraft.setScreen((Screen)screen);
            } else {
                this.minecraft.player.displayClientMessage((Component)Translation.message("controller.main_screen.only_one_keyframe_trigger", new Object[0]).withStyle(ChatFormatting.RED), false);
            }
        }).bounds(startX + (30 + spacing), y, 30, 20).build();
        addKeyframeTrigger.setTooltip(Tooltip.create((Component)Translation.message("tooltip.create_keyframe_trigger", new Object[0])));
        this.addRenderableWidget((GuiEventListener)addKeyframeTrigger);
        Button addCharacter = Button.builder((Component)ImageFontConstants.CHARACTER_ADD, button -> {
            ChooseCharacterScreen screen = new ChooseCharacterScreen((Screen)this, Translation.message("controller.camera_angle.add_character", "Main Screen character list").getString(), null, null, characterStory -> {
                if (characterStory == null) {
                    this.onClose();
                    return;
                }
                Location location = this.mainScreenController.getPlayerSession().getPlayerPosition();
                CharacterStoryData characterStoryData = new CharacterStoryData((CharacterStory)characterStory, location, false);
                characterStoryData.setItems((LivingEntity)this.minecraft.player);
                characterStoryData.setEntityByte((Byte)this.minecraft.player.getEntityData().get(EntityAccessor.getDATA_SHARED_FLAGS_ID()));
                characterStoryData.setLivingEntityByte((Byte)this.minecraft.player.getEntityData().get(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS()));
                characterStoryData.spawn((Level)this.mainScreenController.getPlayerSession().getPlayer().level(), Environment.DEVELOPMENT);
                this.mainScreenController.getCharacterStoryDataList().add(characterStoryData);
                this.minecraft.setScreen(null);
            });
            this.minecraft.setScreen((Screen)screen);
        }).bounds(startX + (30 + spacing) * 2, y, 30, 20).build();
        addCharacter.setTooltip(Tooltip.create((Component)Translation.message("tooltip.add_character", new Object[0])));
        this.addRenderableWidget((GuiEventListener)addCharacter);
        Button saveButton = Button.builder((Component)ImageFontConstants.SAVE, button -> {
            NarrativeCraftMod.server.execute(() -> this.mainScreenController.stopSession(true));
            this.onClose();
        }).bounds(startX + (30 + spacing) * 3, y, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)saveButton);
        Button closeButton = Button.builder((Component)Component.literal((String)"\u2716"), button -> {
            ConfirmScreen confirm = new ConfirmScreen(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> this.mainScreenController.stopSession(false));
                    this.onClose();
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.literal((String)""), (Component)Translation.message("controller.confirm_leaving", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
            this.minecraft.setScreen((Screen)confirm);
        }).bounds(startX + (30 + spacing) * 4, y, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    protected void renderBlurredBackground(GuiGraphics guiGraphics) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }
}

