/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.chapter;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.ChapterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.chapter.EditScreenChapterAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ChaptersScreen
extends StoryElementScreen {
    public ChaptersScreen() {
        super((Component)Translation.message("screen.story_manager.chapter_list", new Object[0]));
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Chapter> screen = new EditInfoScreen<Chapter>(this, null, new EditScreenChapterAdapter());
            this.minecraft.setScreen(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, p_345997_ -> this.onClose()).width(200).build());
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.chaptersDirectory.toPath());
    }

    @Override
    protected void addContents() {
        ChapterManager chapterManager = NarrativeCraftMod.getInstance().getChapterManager();
        List<StoryElementList.StoryEntryData> entries = chapterManager.getChapters().stream().map(chapter -> {
            Object label = String.valueOf(chapter.getIndex());
            if (!chapter.getName().isEmpty()) {
                label = (String)label + " - " + chapter.getName();
            }
            Button button = Button.builder((Component)Component.literal((String)label), b -> this.minecraft.setScreen((Screen)new ScenesScreen((Chapter)chapter))).build();
            return new StoryElementList.StoryEntryData(button, () -> this.minecraft.setScreen(new EditInfoScreen<Chapter>(this, (Chapter)chapter, new EditScreenChapterAdapter())), () -> {
                try {
                    chapterManager.removeChapter((Chapter)chapter);
                    NarrativeCraftFile.deleteChapterDirectory(chapter);
                    this.minecraft.setScreen((Screen)new ChaptersScreen());
                }
                catch (Exception e) {
                    chapterManager.addChapter((Chapter)chapter);
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                }
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }
}

