/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.character;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterModel;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.character.CharactersScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EditScreenCharacterAdapter
implements EditScreenAdapter<CharacterStory> {
    private final Scene scene;

    public EditScreenCharacterAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<CharacterStory> screen, CharacterStory entry) {
        if (this.scene == null) {
            LocalDate localDate = LocalDate.now();
            ScreenUtils.LabelBox dayLabelBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Day"), screen.getFont(), 20, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            screen.extraFields.put("day", dayLabelBox);
            screen.extraFields.put("dayBox", dayLabelBox.getEditBox());
            dayLabelBox.getEditBox().setFilter(string -> string.matches("^\\d*$"));
            dayLabelBox.getEditBox().setValue(String.valueOf(localDate.getDayOfMonth()));
            ScreenUtils.LabelBox monthLabelBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Month"), screen.getFont(), 20, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            monthLabelBox.getEditBox().setFilter(string -> string.matches("^\\d*$"));
            monthLabelBox.getEditBox().setValue(String.valueOf(localDate.getMonthValue()));
            screen.extraFields.put("month", monthLabelBox);
            ScreenUtils.LabelBox yearLabelBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Year"), screen.getFont(), 32, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            yearLabelBox.getEditBox().setFilter(string -> string.matches("^\\d*$"));
            yearLabelBox.getEditBox().setValue("2000");
            screen.extraFields.put("year", yearLabelBox);
        }
        Button modelButton = Button.builder((Component)Component.literal((String)CharacterModel.WIDE.name()), button -> {
            String currentModel = button.getMessage().getString();
            if (currentModel.equalsIgnoreCase(CharacterModel.WIDE.name())) {
                button.setMessage((Component)Component.literal((String)CharacterModel.SLIM.name()));
            } else {
                button.setMessage((Component)Component.literal((String)CharacterModel.WIDE.name()));
            }
        }).width(70).build();
        screen.extraFields.put("modelBtn", modelButton);
        if (entry != null) {
            if (this.scene == null) {
                String[] birthDateSplit = entry.getBirthDate().split("/");
                try {
                    ScreenUtils.LabelBox dayLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("day");
                    ScreenUtils.LabelBox monthLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("month");
                    ScreenUtils.LabelBox yearLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("year");
                    dayLabelBox.getEditBox().setValue(birthDateSplit[0]);
                    monthLabelBox.getEditBox().setValue(birthDateSplit[1]);
                    yearLabelBox.getEditBox().setValue(birthDateSplit[2]);
                }
                catch (Exception e) {
                    Util.sendCrashMessage((Player)Minecraft.getInstance().player, e);
                    Minecraft.getInstance().setScreen(null);
                }
            }
            modelButton.setMessage((Component)Component.literal((String)entry.getModel().name()));
        }
    }

    @Override
    public void renderExtraFields(EditInfoScreen<CharacterStory> screen, CharacterStory entry, int x, int y) {
        if (this.scene == null) {
            ScreenUtils.LabelBox dayLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("day");
            dayLabelBox.setPosition(x, y);
            screen.addRenderableWidget((CharacterStory)dayLabelBox.getEditBox());
            screen.addRenderableWidget((CharacterStory)dayLabelBox.getStringWidget());
            ScreenUtils.LabelBox monthLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("month");
            monthLabelBox.setPosition(dayLabelBox.getEditBox().getX() + dayLabelBox.getEditBox().getWidth() + 10, y);
            screen.addRenderableWidget((CharacterStory)monthLabelBox.getEditBox());
            screen.addRenderableWidget((CharacterStory)monthLabelBox.getStringWidget());
            ScreenUtils.LabelBox yearLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("year");
            yearLabelBox.setPosition(monthLabelBox.getEditBox().getX() + monthLabelBox.getEditBox().getWidth() + 10, y);
            screen.addRenderableWidget((CharacterStory)yearLabelBox.getEditBox());
            screen.addRenderableWidget((CharacterStory)yearLabelBox.getStringWidget());
            y += yearLabelBox.getEditBox().getHeight() + screen.GAP;
        }
        Button modelButton = (Button)screen.extraFields.get("modelBtn");
        MutableComponent label = Component.literal((String)"Model");
        Font font = screen.getFont();
        int n = y + modelButton.getHeight() / 2;
        Objects.requireNonNull(screen.getFont());
        StringWidget modelText = ScreenUtils.text((Component)label, font, x, n - 9 / 2);
        screen.addRenderableWidget((CharacterStory)modelText);
        modelButton.setPosition(x + modelText.getWidth() + 5, y);
        screen.addRenderableWidget((CharacterStory)modelButton);
    }

    @Override
    public void buildFromScreen(Map<String, Object> extraFields, Minecraft minecraft, @Nullable CharacterStory existing, String name, String description) {
        CharacterStory newCharacter;
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        CharacterModel model = CharacterModel.valueOf(((Button)extraFields.get("modelBtn")).getMessage().getString());
        if (this.scene == null) {
            String day = ((ScreenUtils.LabelBox)extraFields.get("day")).getEditBox().getValue();
            String month = ((ScreenUtils.LabelBox)extraFields.get("month")).getEditBox().getValue();
            String year = ((ScreenUtils.LabelBox)extraFields.get("year")).getEditBox().getValue();
            newCharacter = new CharacterStory(name, description, day, month, year, model, CharacterType.MAIN);
        } else {
            newCharacter = new CharacterStory(name, description, "You", "are", "handsome <3", model, CharacterType.NPC);
        }
        if (existing == null) {
            if (characterManager.characterExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("character.already_exists", name));
                return;
            }
            try {
                if (this.scene == null) {
                    NarrativeCraftFile.createCharacterFolder(newCharacter);
                    characterManager.addCharacter(newCharacter);
                } else {
                    NarrativeCraftFile.createCharacterFolder(newCharacter, this.scene);
                    this.scene.addNpc(newCharacter);
                }
                minecraft.setScreen((Screen)new CharactersScreen(this.scene));
            }
            catch (Exception e) {
                Util.sendCrashMessage((Player)minecraft.player, e);
                minecraft.setScreen(null);
            }
        } else {
            List<Chapter> chapters = NarrativeCraftMod.getInstance().getChapterManager().getChapters();
            try {
                if (this.scene == null) {
                    NarrativeCraftFile.updateCharacterData(existing, newCharacter);
                } else {
                    NarrativeCraftFile.updateCharacterData(existing, newCharacter, this.scene);
                }
                existing.setName(newCharacter.getName());
                existing.setDescription(newCharacter.getDescription());
                if (this.scene == null) {
                    existing.setBirthDate(newCharacter.getBirthDate());
                }
                existing.setModel(newCharacter.getModel());
                for (Chapter chapter : chapters) {
                    for (Scene scene : chapter.getSortedSceneList()) {
                        for (Animation animation : scene.getAnimations()) {
                            NarrativeCraftFile.updateAnimationFile(animation);
                        }
                        NarrativeCraftFile.updateCameraAngles(scene);
                    }
                }
                minecraft.setScreen((Screen)new CharactersScreen(this.scene));
            }
            catch (Exception e) {
                Util.sendCrashMessage((Player)minecraft.player, e);
                minecraft.setScreen(null);
            }
        }
    }
}

