/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.PickElementScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.cutscene.EditScreenCutsceneAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class CutscenesScreen
extends StoryElementScreen {
    private final Scene scene;
    private Button settingsButton;

    public CutscenesScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.cutscene_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Cutscene> screen = new EditInfoScreen<Cutscene>(this, null, new EditScreenCutsceneAdapter(this.scene));
            this.minecraft.setScreen(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(200).build());
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getCutscenes().stream().map(cutscene -> {
            Button button = Button.builder((Component)Component.literal((String)cutscene.getName()), button1 -> {
                NarrativeCraftMod.server.execute(() -> new CutsceneController(Environment.DEVELOPMENT, (Player)this.minecraft.player, (Cutscene)cutscene).startSession());
                this.minecraft.setScreen(null);
            }).build();
            this.settingsButton = this.createSettingsButton((Cutscene)cutscene);
            this.settingsButton.setTooltip(Tooltip.create((Component)(CutscenesScreen.hasShiftDown() ? Translation.message("screen.story_manager.animation_cutscene_link", new Object[0]) : Translation.message("screen.story_manager.subscene_cutscene_link", new Object[0]))));
            return new StoryElementList.StoryEntryData(button, List.of(this.settingsButton), () -> this.minecraft.setScreen(new EditInfoScreen<Cutscene>(this, (Cutscene)cutscene, new EditScreenCutsceneAdapter(this.scene))), () -> {
                this.minecraft.setScreen((Screen)new CutscenesScreen(this.scene));
                try {
                    this.scene.removeCutscene((Cutscene)cutscene);
                    NarrativeCraftFile.updateCutsceneFile(this.scene);
                    this.minecraft.setScreen((Screen)new CutscenesScreen(this.scene));
                }
                catch (Exception e) {
                    this.scene.addCutscene((Cutscene)cutscene);
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                }
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    private Button createSettingsButton(Cutscene cutscene) {
        List<Subscene> subscenesAvailable = this.scene.getSubscenes().stream().filter(sub -> cutscene.getSubscenes().stream().noneMatch(s -> s.getName().equals(sub.getName()))).toList();
        List<Animation> animationsAvailable = this.scene.getAnimations().stream().filter(anim -> cutscene.getAnimations().stream().noneMatch(a -> a.getName().equals(anim.getName()))).toList();
        return Button.builder((Component)ImageFontConstants.SETTINGS, button -> {
            PickElementScreen screen = Screen.hasShiftDown() ? new PickElementScreen(this, (Component)Translation.message("screen.pick.cutscene.title", Translation.message("global.animations", new Object[0]), Component.literal((String)cutscene.getName())), (Component)Translation.message("global.animations", new Object[0]), animationsAvailable, cutscene.getAnimations(), entries -> {
                ArrayList<Animation> selectedAnimations = new ArrayList<Animation>();
                for (PickElementScreen.TransferableStorySelectionList.Entry entry : entries) {
                    Animation animation = (Animation)entry.getNarrativeEntry();
                    selectedAnimations.add(animation);
                }
                List<Animation> oldAnimations = cutscene.getAnimations();
                try {
                    cutscene.getAnimations().clear();
                    cutscene.getAnimations().addAll(selectedAnimations);
                    NarrativeCraftFile.updateCutsceneFile(this.scene);
                    this.minecraft.setScreen((Screen)new CutscenesScreen(this.scene));
                }
                catch (Exception e) {
                    cutscene.getAnimations().addAll(oldAnimations);
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                    this.minecraft.setScreen(null);
                }
            }) : new PickElementScreen(this, (Component)Translation.message("screen.pick.cutscene.title", Translation.message("global.subscenes", new Object[0]), Component.literal((String)cutscene.getName())), (Component)Translation.message("global.subscenes", new Object[0]), subscenesAvailable, cutscene.getSubscenes(), entries -> {
                ArrayList<Subscene> selectedSubscene = new ArrayList<Subscene>();
                for (PickElementScreen.TransferableStorySelectionList.Entry entry : entries) {
                    Subscene subscene = (Subscene)entry.getNarrativeEntry();
                    selectedSubscene.add(subscene);
                }
                List<Subscene> oldSubscenes = cutscene.getSubscenes();
                try {
                    cutscene.getSubscenes().clear();
                    cutscene.getSubscenes().addAll(selectedSubscene);
                    NarrativeCraftFile.updateCutsceneFile(this.scene);
                    this.minecraft.setScreen((Screen)new CutscenesScreen(this.scene));
                }
                catch (Exception e) {
                    cutscene.getSubscenes().addAll(oldSubscenes);
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                    this.minecraft.setScreen(null);
                }
            });
            this.minecraft.setScreen((Screen)screen);
        }).width(20).build();
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.getDataFolder(this.scene).toPath());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.settingsButton.setTooltip(Tooltip.create((Component)Translation.message("screen.story_manager.animation_cutscene_link", new Object[0])));
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.settingsButton.setTooltip(Tooltip.create((Component)Translation.message("screen.story_manager.subscene_cutscene_link", new Object[0])));
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

