/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import com.mojang.authlib.GameProfile;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Util;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class PlayerInfoMixin {
    @Shadow
    @Final
    private GameProfile profile;

    @Inject(method={"getSkin"}, at={@At(value="RETURN")}, cancellable=true)
    private void narrativecraft$getSkin(CallbackInfoReturnable<PlayerSkin> cir) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.getInstance().player);
        if (playerSession == null) {
            return;
        }
        ArrayList<CharacterRuntime> characterRuntimes = new ArrayList<CharacterRuntime>(playerSession.getCharacterRuntimes());
        for (CharacterRuntime characterRuntime : characterRuntimes) {
            if (characterRuntime.getEntity() == null || !this.profile.getName().equals(characterRuntime.getCharacterStory().getName())) continue;
            PlayerSkin.Model model = PlayerSkin.Model.WIDE;
            try {
                model = PlayerSkin.Model.valueOf((String)characterRuntime.getCharacterStory().getModel().name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            File currentSkin = characterRuntime.getCharacterSkinController().getCurrentSkin();
            if (currentSkin == null) {
                return;
            }
            ResourceLocation skinLocation = ResourceLocation.fromNamespaceAndPath((String)"narrativecraft", (String)("character/" + Util.snakeCase(characterRuntime.getCharacterStory().getName()) + "/" + Util.snakeCase(currentSkin.getName())));
            PlayerSkin playerSkin = new PlayerSkin(skinLocation, null, null, null, model, true);
            cir.setReturnValue((Object)playerSkin);
        }
    }
}

