/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class BorderInkAction
extends InkAction {
    private int up;
    private int right;
    private int down;
    private int left;
    private int color;
    private double opacity;

    public BorderInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void render(GuiGraphics guiGraphics, float partialTick) {
        if (!this.isRunning) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        int widthScreen = minecraft.getWindow().getGuiScaledWidth();
        int heightScreen = minecraft.getWindow().getGuiScaledHeight();
        int guiScale = (Integer)minecraft.options.guiScale().get();
        if ((Integer)minecraft.options.guiScale().get() == 0) {
            guiScale = 3;
        }
        guiGraphics.fill(0, 0, widthScreen, this.up / guiScale, this.color);
        guiGraphics.fill(widthScreen - this.right / guiScale, 0, widthScreen, heightScreen, this.color);
        guiGraphics.fill(0, heightScreen - this.down / guiScale, widthScreen, heightScreen, this.color);
        guiGraphics.fill(0, 0, this.left / guiScale, heightScreen, this.color);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() < 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Up value missing"));
        }
        if (arguments.size() < 3) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Right value missing"));
        }
        if (arguments.size() < 4) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Down value missing"));
        }
        if (arguments.size() < 5) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Left value missing"));
        }
        if (arguments.size() < 6) {
            try {
                this.up = Integer.parseInt(arguments.get(1)) * 2;
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(1)));
            }
            try {
                this.right = Integer.parseInt(arguments.get(2)) * 2;
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(2)));
            }
            try {
                this.down = Integer.parseInt(arguments.get(3)) * 2;
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
            }
            try {
                this.left = Integer.parseInt(arguments.get(4)) * 2;
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(4)));
            }
        }
        try {
            this.color = Integer.parseInt(arguments.get(6), 16);
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.color", arguments.get(6)));
        }
        this.opacity = 1.0;
        if (arguments.size() > 6) {
            try {
                this.opacity = Integer.parseInt(arguments.get(6));
                if (this.opacity > 1.0) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "The opacity value is greater than 1"));
                }
                if (this.opacity < 0.0) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "The opacity value is less than 0"));
                }
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(6)));
            }
        }
        this.color = ARGB.color((int)((int)(this.opacity * 255.0)), (int)this.color);
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

