/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.api.inkAction.InkActionUtil;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.network.chat.Component;

public class CooldownInkAction
extends InkAction {
    private double totalTick;
    private double currentTick;

    public CooldownInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (!this.isRunning) {
            return;
        }
        this.currentTick += 1.0;
        if (this.currentTick >= this.totalTick) {
            this.isRunning = false;
            this.blockEndTask.run();
        }
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        double waitSeconds;
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Cooldown value"));
        }
        try {
            waitSeconds = Double.parseDouble(arguments.get(1));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(1)));
        }
        if (arguments.size() == 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_time_value", new Object[0]));
        }
        String timeValue = arguments.get(2);
        if ((waitSeconds = InkActionUtil.getSecondsFromTimeValue(waitSeconds, timeValue)) == -1.0) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_time_value", new Object[0]));
        }
        if (waitSeconds > 2.0) {
            waitSeconds -= 1.0;
        }
        this.totalTick = waitSeconds * 20.0;
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        return InkActionResult.block();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

