/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.util.ScreenUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class EntryBoxScreen
extends Screen {
    private final Screen lastScreen;
    private final Consumer<String> consumer;
    private final Component label;
    private String defaultValue = "";

    public EntryBoxScreen(Screen lastScreen, Component label, Consumer<String> consumer) {
        super((Component)Component.literal((String)"Entry box"));
        this.lastScreen = lastScreen;
        this.consumer = consumer;
        this.label = label;
    }

    public EntryBoxScreen(Screen lastScreen, Component label, String defaultValue, Consumer<String> consumer) {
        super((Component)Component.literal((String)"Entry box"));
        this.lastScreen = lastScreen;
        this.consumer = consumer;
        this.label = label;
        this.defaultValue = defaultValue;
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void init() {
        int globalWidth = 150;
        int globalHeight = 20;
        int globalGap = 5;
        ScreenUtils.LabelBox labelBox = new ScreenUtils.LabelBox(this.label, this.minecraft.font, globalWidth, globalHeight, (this.width - globalWidth) / 2, this.height / 2 - globalHeight / 2 - globalHeight * 3 / 2, ScreenUtils.Align.VERTICAL);
        labelBox.getEditBox().setFilter(text -> text.matches("[a-zA-Z0-9 _-]*"));
        labelBox.getEditBox().setValue(this.defaultValue);
        this.addRenderableWidget((GuiEventListener)labelBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)labelBox.getEditBox());
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.consumer.accept(labelBox.getEditBox().getValue())).bounds((this.width - globalWidth) / 2, labelBox.getEditBox().getY() + labelBox.getEditBox().getHeight() + globalGap, globalWidth, globalHeight).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        Button backButton = Button.builder((Component)CommonComponents.GUI_BACK, button -> this.onClose()).bounds((this.width - globalWidth) / 2, doneButton.getY() + doneButton.getHeight() + globalGap, globalWidth, globalHeight).build();
        this.addRenderableWidget((GuiEventListener)backButton);
        this.minecraft.options.hideGui = false;
    }
}

