/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cameraAngle;

import fr.loudo.narrativecraft.controllers.cameraAngle.CameraAngleController;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cameraAngle.CameraAngleKeyframe;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.EntryBoxScreen;
import fr.loudo.narrativecraft.screens.components.KeyframeOptionScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CameraAngleOptionsScreen
extends KeyframeOptionScreen<CameraAngleKeyframe, CameraAngleController> {
    public CameraAngleOptionsScreen(CameraAngleKeyframe keyframe, CameraAngleController keyframeController, PlayerSession playerSession, boolean hide) {
        super(keyframe, keyframeController, playerSession, hide);
        this.reloadScreen = () -> this.minecraft.setScreen((Screen)new CameraAngleOptionsScreen(keyframe, keyframeController, playerSession, false));
    }

    @Override
    protected void init() {
        if (!this.hide) {
            this.initPositionLabelBox();
            this.initButtons();
            this.initSliders();
            this.initTextSelectedKeyframe();
        }
        this.initLittleButtons();
        this.currentY = 15;
    }

    public void onClose() {
    }

    @Override
    protected void initLittleButtons() {
        super.initLittleButtons();
        if (this.hide) {
            return;
        }
        Button editButton = Button.builder((Component)ImageFontConstants.EDIT, button -> {
            EntryBoxScreen screen = new EntryBoxScreen(this, (Component)Translation.message("global.name", new Object[0]), ((CameraAngleKeyframe)this.keyframe).getName(), name -> {
                if (name.isEmpty()) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("camera_angle.name_no_empty", name, ((CameraAngleController)this.keyframeController).getCameraAngle().getName()));
                } else if (((CameraAngleController)this.keyframeController).getKeyframeByName((String)name) != null) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("camera_angle.already_exists", name, ((CameraAngleController)this.keyframeController).getCameraAngle().getName()));
                } else {
                    this.minecraft.options.hideGui = true;
                    ((CameraAngleKeyframe)this.keyframe).setName((String)name);
                    this.onClose();
                }
            });
            this.minecraft.setScreen((Screen)screen);
        }).bounds(((Button)this.littleButtons.getLast()).getX() - 25, 10, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)editButton);
    }

    @Override
    protected void initTextSelectedKeyframe() {
        int y = 10;
        String cameraAngleName = ((CameraAngleKeyframe)this.keyframe).getName();
        this.addRenderableWidget((GuiEventListener)ScreenUtils.text((Component)Component.literal((String)cameraAngleName), this.font, this.width / 2 - this.font.width(cameraAngleName) / 2, y));
    }

    @Override
    protected void initButtons() {
        MutableComponent updateTitle = Translation.message("screen.keyframe_option.update", new Object[0]);
        Button updateButton = Button.builder((Component)updateTitle, button -> this.updateValues()).bounds(20, this.currentY, this.font.width((FormattedText)updateTitle) + 30, 20).build();
        this.addRenderableWidget((GuiEventListener)updateButton);
        this.currentY += 35;
        MutableComponent removeTitle = Translation.message("global.remove", new Object[0]);
        Button removeKeyframe = Button.builder((Component)removeTitle, button -> {
            ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                if (b) {
                    if (this.playerSession != null) {
                        ((CameraAngleController)this.keyframeController).setCamera(null);
                        ((CameraAngleController)this.keyframeController).removeKeyframe((CameraAngleKeyframe)this.keyframe);
                        this.minecraft.setScreen(null);
                    }
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.literal((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
            this.minecraft.setScreen((Screen)confirmScreen);
        }).bounds(20, this.currentY, this.font.width((FormattedText)removeTitle) + 15, 20).build();
        this.addRenderableWidget((GuiEventListener)removeKeyframe);
    }

    @Override
    protected void updateValues() {
        KeyframeLocation position = ((CameraAngleKeyframe)this.keyframe).getKeyframeLocation();
        try {
            float xVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(0)).getValue());
            float yVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(1)).getValue());
            float zVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(2)).getValue());
            position.setX(xVal);
            position.setY(yVal);
            position.setZ(zVal);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        position.setPitch(this.upDownValue);
        position.setYaw(this.leftRightValue);
        position.setRoll(this.rotationValue);
        position.setFov(this.fovValue);
        ((CameraAngleKeyframe)this.keyframe).setKeyframeLocation(position);
        ((CameraAngleKeyframe)this.keyframe).updateEntityData(this.player);
    }
}

