/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CutsceneChangeTimeSkipScreen
extends Screen {
    private final int INPUT_WIDTH = 100;
    private final int BUTTON_WIDTH = 60;
    private final int BUTTON_HEIGHT = 20;
    private final Screen lastScreen;
    private final CutsceneController cutsceneController;
    private EditBox numberInput;

    public CutsceneChangeTimeSkipScreen(CutsceneController cutsceneController, Screen lastScreen) {
        super((Component)Component.literal((String)"Change Time Skip Screen"));
        this.cutsceneController = cutsceneController;
        this.lastScreen = lastScreen;
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void init() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int inputX = centerX - 82;
        this.numberInput = new EditBox(this.font, inputX, centerY - 20, 120, 20, (Component)Component.literal((String)"Number"));
        this.numberInput.setFilter(s -> s.matches("^\\d*(\\.\\d*)?$"));
        this.numberInput.setMaxLength(10);
        this.addRenderableWidget((GuiEventListener)this.numberInput);
        int updateX = inputX + 100 + 30;
        Button updateButton = Button.builder((Component)Translation.message("global.update", new Object[0]), button -> {
            String input = this.numberInput.getValue();
            if (!input.isEmpty()) {
                double value = Double.parseDouble(input);
                this.cutsceneController.setSkipTickCount((int)(value * 20.0));
                Minecraft.getInstance().player.displayClientMessage((Component)Translation.message("controller.cutscene.changed_time_skip_value", value), false);
                this.minecraft.setScreen(null);
            }
        }).bounds(updateX, centerY - 20, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)updateButton);
        double[] values = new double[]{0.5, 1.0, 5.0, 10.0, 15.0, 60.0};
        int buttonCount = values.length;
        int totalTopWidth = 165;
        int buttonWidth = 30;
        int totalButtonsWidth = buttonCount * buttonWidth;
        int spacing = (totalTopWidth - totalButtonsWidth) / (buttonCount - 1);
        for (int i = 0; i < buttonCount; ++i) {
            double val = values[i];
            int x = inputX + i * (buttonWidth + spacing + 5);
            Button b = Button.builder((Component)Component.literal((String)String.valueOf(val)), button -> this.numberInput.setValue(String.valueOf(val))).bounds(x, centerY + 10, buttonWidth, 20).build();
            this.addRenderableWidget((GuiEventListener)b);
        }
    }
}

