/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.options;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.data.MainScreenData;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.options.DialogCustomOptionsScreen;
import fr.loudo.narrativecraft.screens.options.WorldOptionsScreen;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class StoryOptionsScreen
extends StoryElementScreen {
    private final PlayerSession playerSession;

    public StoryOptionsScreen(PlayerSession playerSession) {
        super((Component)Translation.message("screen.story_options.title", new Object[0]));
        this.playerSession = playerSession;
    }

    @Override
    protected void addTitle() {
        this.linearlayout = ((LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.horizontal())).spacing(8);
        this.linearlayout.addChild((LayoutElement)Button.builder((Component)ImageFontConstants.FOLDER, button -> this.openFolder()).width(25).build());
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.dataDirectory.toPath());
    }

    @Override
    protected void addContents() {
        ArrayList<StoryElementList.StoryEntryData> entries = new ArrayList<StoryElementList.StoryEntryData>();
        entries.add(new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("screen.story_options.main_screen", new Object[0]), button -> {
            NarrativeCraftMod.server.execute(() -> {
                try {
                    MainScreenData mainScreenData = NarrativeCraftFile.getMainScreenBackground();
                    MainScreenController mainScreenController = new MainScreenController(Environment.DEVELOPMENT, (Player)this.minecraft.player, mainScreenData);
                    mainScreenController.startSession();
                }
                catch (IOException e) {
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                }
            });
            this.onClose();
        }).build()));
        entries.add(new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("screen.story_options.dialog", new Object[0]), button -> {
            DialogCustomOptionsScreen dialogCustomScreen = new DialogCustomOptionsScreen(this, this.playerSession);
            this.minecraft.setScreen((Screen)dialogCustomScreen);
        }).build()));
        entries.add(new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("screen.story_options.world_options", new Object[0]), button -> {
            WorldOptionsScreen screen = new WorldOptionsScreen(this);
            this.minecraft.setScreen((Screen)screen);
        }).build()));
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }
}

