/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.chapter.scene;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.CameraAngle;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;

public class Scene
extends NarrativeEntry {
    private final Chapter chapter;
    private final List<Animation> animations = new ArrayList<Animation>();
    private final List<Cutscene> cutscenes = new ArrayList<Cutscene>();
    private final List<Subscene> subscenes = new ArrayList<Subscene>();
    private final List<CameraAngle> cameraAngles = new ArrayList<CameraAngle>();
    private final List<CharacterStory> npcs = new ArrayList<CharacterStory>();
    private List<Interaction> interactions = new ArrayList<Interaction>();
    private int rank;

    public Scene(String name, String description, Chapter chapter) {
        super(name, description);
        this.chapter = chapter;
        this.rank = chapter.getScenes().size() + 1;
    }

    public String knotName() {
        return "chapter_" + this.chapter.getIndex() + "_" + Util.snakeCase(this.name.toLowerCase());
    }

    public String folderName() {
        return this.chapter.getIndex() + "_" + this.rank + "_" + Util.snakeCase(this.name);
    }

    public Animation getAnimationByName(String name) {
        for (Animation animation : this.animations) {
            if (!animation.getName().equalsIgnoreCase(name)) continue;
            return animation;
        }
        return null;
    }

    public Subscene getSubsceneByName(String name) {
        for (Subscene subscene : this.subscenes) {
            if (!subscene.getName().equalsIgnoreCase(name)) continue;
            return subscene;
        }
        return null;
    }

    public boolean subsceneExists(String name) {
        for (Subscene subscene : this.subscenes) {
            if (!subscene.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Cutscene getCutsceneByName(String name) {
        for (Cutscene cutscene : this.cutscenes) {
            if (!cutscene.getName().equalsIgnoreCase(name)) continue;
            return cutscene;
        }
        return null;
    }

    public boolean cutsceneExists(String name) {
        for (Cutscene cutscene : this.cutscenes) {
            if (!cutscene.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean animationExists(String name) {
        for (Animation animation : this.animations) {
            if (!animation.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void addCameraAngleGroup(CameraAngle cameraAngleGroup) {
        if (this.cameraAngles.contains(cameraAngleGroup)) {
            return;
        }
        this.cameraAngles.add(cameraAngleGroup);
    }

    public void removeCameraAngleGroup(CameraAngle cameraAngleGroup) {
        this.cameraAngles.remove(cameraAngleGroup);
    }

    public void addInteraction(Interaction interaction) {
        if (this.interactions.contains(interaction)) {
            return;
        }
        this.interactions.add(interaction);
    }

    public void removeInteraction(Interaction interaction) {
        this.interactions.remove(interaction);
    }

    public CameraAngle getCameraAngleByName(String name) {
        for (CameraAngle cameraAngle : this.cameraAngles) {
            if (!cameraAngle.getName().equalsIgnoreCase(name)) continue;
            return cameraAngle;
        }
        return null;
    }

    public boolean cameraAngleExists(String name) {
        for (CameraAngle cameraAngle : this.cameraAngles) {
            if (!cameraAngle.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean interactionExists(String name) {
        for (Interaction interaction : this.interactions) {
            if (!interaction.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Interaction getInteractionByName(String name) {
        for (Interaction interaction : this.interactions) {
            if (!interaction.getName().equalsIgnoreCase(name)) continue;
            return interaction;
        }
        return null;
    }

    public void addNpc(CharacterStory characterStory) {
        if (this.npcs.contains(characterStory)) {
            return;
        }
        this.npcs.add(characterStory);
    }

    public void removeNpc(CharacterStory characterStory) {
        this.npcs.remove(characterStory);
    }

    public CharacterStory getNpcByName(String name) {
        for (CharacterStory characterStory : this.npcs) {
            if (!characterStory.getName().equalsIgnoreCase(name)) continue;
            return characterStory;
        }
        return null;
    }

    public void addSubscene(Subscene subscene) {
        if (this.subscenes.contains(subscene)) {
            return;
        }
        this.subscenes.add(subscene);
    }

    public void removeSubscene(Subscene subscene) {
        this.subscenes.remove(subscene);
    }

    public void addCutscene(Cutscene cutscene) {
        if (this.cutscenes.contains(cutscene)) {
            return;
        }
        this.cutscenes.add(cutscene);
    }

    public void removeCutscene(Cutscene cutscene) {
        this.cutscenes.remove(cutscene);
    }

    public void addAnimation(Animation animation) {
        if (this.animations.contains(animation)) {
            return;
        }
        this.animations.add(animation);
    }

    public void removeAnimation(Animation animation) {
        this.animations.remove(animation);
    }

    public List<Interaction> getInteractions() {
        if (this.interactions == null) {
            this.interactions = new ArrayList<Interaction>();
        }
        return this.interactions;
    }

    public AreaTrigger getAreaTriggerByName(String name) {
        for (Interaction interaction : this.interactions) {
            for (AreaTrigger areaTrigger : interaction.getAreaTriggers()) {
                if (!areaTrigger.getName().equalsIgnoreCase(name)) continue;
                return areaTrigger;
            }
        }
        return null;
    }

    public void setInteractions(List<Interaction> interactions) {
        this.interactions = interactions;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public List<Animation> getAnimations() {
        return this.animations;
    }

    public List<Cutscene> getCutscenes() {
        return this.cutscenes;
    }

    public List<Subscene> getSubscenes() {
        return this.subscenes;
    }

    public List<CameraAngle> getCameraAngles() {
        return this.cameraAngles;
    }

    public List<CharacterStory> getNpcs() {
        return this.npcs;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }
}

