/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.narrative.story.text.TextEffectAnimation;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import org.joml.Vector2f;

public abstract class AbstractDialogScrollText {
    protected final class_310 minecraft;
    protected final List<LetterLocation> lettersRenderer = new ArrayList<LetterLocation>();
    protected TextEffectAnimation textEffectAnimation;
    protected List<String> lines = new ArrayList<String>();
    protected int currentLine;
    protected int currentCharIndex;
    protected int index;
    protected float currentX;
    protected float currentY;
    protected float tickAccumulator = 0.0f;
    protected class_2960 letterSound = class_2960.method_60655((String)"narrativecraft", (String)"sfx.dialog_sound");
    protected int textColor = 0xFFFFFF;
    protected float textSpeed = 1.0f;
    protected float letterSpacing = 0.0f;
    protected float gap = 0.0f;
    protected boolean muteSound;

    public AbstractDialogScrollText(class_310 minecraft) {
        this.minecraft = minecraft;
        this.textSpeed = NarrativeCraftMod.getInstance().getNarrativeClientOptions().textSpeed;
    }

    public void setText(String text) {
        text = text.replace("\n", "").trim();
        ParsedDialog parsedDialog = ParsedDialog.parse(text);
        this.lines = this.splitTextIntoLines(parsedDialog.cleanedText());
        this.textEffectAnimation = new TextEffectAnimation(parsedDialog);
    }

    protected abstract List<String> splitTextIntoLines(String var1);

    protected abstract float getInitialX();

    protected abstract float getInitialY();

    public void reset() {
        this.currentLine = 0;
        this.currentCharIndex = 0;
        this.index = 0;
        this.tickAccumulator = 0.0f;
        this.currentX = this.getInitialX();
        this.currentY = this.getInitialY();
        this.lettersRenderer.clear();
    }

    public void forceFinish() {
        while (!this.isFinished()) {
            this.addLetter();
        }
    }

    public void tick() {
        if (this.textEffectAnimation != null) {
            this.textEffectAnimation.tick();
            if (!this.textEffectAnimation.canTick(this.index)) {
                return;
            }
        }
        if (!this.isFinished() && this.canScroll()) {
            this.tickAccumulator += 1.0f;
            this.populateLetters();
        }
    }

    protected abstract boolean canScroll();

    protected void populateLetters() {
        boolean playSound = false;
        while (this.tickAccumulator >= this.textSpeed && this.currentLine < this.lines.size()) {
            char letter = this.addLetter();
            if (letter != ' ') {
                playSound = true;
            }
            this.tickAccumulator -= this.textSpeed;
        }
        if (playSound && !this.muteSound) {
            this.playLetterSound();
        }
    }

    protected char addLetter() {
        if (this.currentLine >= this.lines.size()) {
            return ' ';
        }
        String currentLineText = this.lines.get(this.currentLine);
        if (currentLineText.isEmpty() || this.currentCharIndex >= currentLineText.length()) {
            if (this.lines.size() > 1 && this.currentLine < this.lines.size() - 1) {
                this.moveToNextLine();
            }
            return ' ';
        }
        char letter = currentLineText.charAt(this.currentCharIndex);
        this.lettersRenderer.add(new LetterLocation(letter, this.currentX, this.currentY, true));
        this.currentX += Util.getLetterWidth(letter, this.minecraft) + this.letterSpacing;
        ++this.currentCharIndex;
        if (this.currentCharIndex >= currentLineText.length() && this.lines.size() > 1 && this.currentLine < this.lines.size() - 1) {
            this.moveToNextLine();
        }
        ++this.index;
        return letter;
    }

    protected void moveToNextLine() {
        this.lettersRenderer.add(new LetterLocation(' ', this.currentX, this.currentY, false));
        ++this.currentLine;
        this.currentCharIndex = 0;
        this.currentX = this.getInitialX();
        Objects.requireNonNull(this.minecraft.field_1772);
        this.currentY += 9.0f + this.gap;
    }

    protected void playLetterSound() {
        float pitch = 0.8f + new Random().nextFloat() * 0.4f;
        class_3414 soundEvent = class_3414.method_47908((class_2960)this.letterSound);
        this.minecraft.field_1724.method_5783(soundEvent, 1.0f, pitch);
    }

    public boolean isFinished() {
        return this.currentLine == this.lines.size() - 1 && this.currentCharIndex == this.lines.getLast().length();
    }

    public String getLongerTextLine() {
        return Util.getLongerTextLine(this.lines, this.minecraft);
    }

    public List<String> getLines() {
        return this.lines;
    }

    public Map<Integer, Vector2f> getTextEffectOffsets(float partialTick) {
        if (this.textEffectAnimation != null) {
            return this.textEffectAnimation.getOffsets(partialTick);
        }
        return Collections.emptyMap();
    }

    public List<LetterLocation> getLettersRenderer() {
        return this.lettersRenderer;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public float getTextSpeed() {
        return this.textSpeed;
    }

    public void setTextSpeed(float textSpeed) {
        this.textSpeed = textSpeed;
    }

    public void setLetterSpacing(float letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public void setGap(float gap) {
        this.gap = gap;
    }

    public boolean isMuteSound() {
        return this.muteSound;
    }

    public void setMuteSound(boolean muteSound) {
        this.muteSound = muteSound;
    }

    public class_2960 getLetterSound() {
        return this.letterSound;
    }

    public void setLetterSound(class_2960 letterSound) {
        this.letterSound = letterSound;
    }

    public record LetterLocation(char letter, float x, float y, boolean render) {
    }
}

