/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.inkTag;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.inkTag.InkTagHandlerException;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;

public class InkTagHandler {
    private final PlayerSession playerSession;
    private List<String> tagsToExecute = new ArrayList<String>();
    private Runnable run;

    public InkTagHandler(PlayerSession playerSession) {
        this.playerSession = playerSession;
    }

    public void execute() throws InkTagHandlerException {
        InkActionResult result = InkActionResult.ok();
        StoryHandler storyHandler = this.playerSession.getStoryHandler();
        for (int i = 0; i < this.tagsToExecute.size(); ++i) {
            InkAction inkAction;
            String tag = this.tagsToExecute.get(i);
            if (storyHandler != null) {
                tag = InkUtil.parseVariables(storyHandler.getStory(), tag);
            }
            if ((inkAction = InkActionRegistry.findByCommand(tag)) == null) continue;
            result = inkAction.validate(tag, this.playerSession.getScene());
            if (result.isError()) {
                throw new InkTagHandlerException(inkAction.getClass(), result.errorMessage());
            }
            result = inkAction.execute(this.playerSession);
            if (result.isError()) {
                throw new InkTagHandlerException(inkAction.getClass(), result.errorMessage());
            }
            if (result.isBlock()) {
                inkAction.setBlockEndTask(() -> {
                    inkAction.setRunning(false);
                    try {
                        this.execute();
                    }
                    catch (InkTagHandlerException e) {
                        if (this.playerSession.getStoryHandler() == null) {
                            Util.sendCrashMessage((class_1657)this.playerSession.getPlayer(), e);
                        }
                        this.playerSession.getStoryHandler().showCrash(e);
                        this.playerSession.getStoryHandler().stop();
                    }
                });
            }
            if (result.isIgnore()) {
                inkAction.setRunning(false);
            }
            this.playerSession.addInkAction(inkAction);
            if (!result.isBlock()) continue;
            this.tagsToExecute = this.tagsToExecute.subList(i + 1, this.tagsToExecute.size());
            return;
        }
        this.tagsToExecute.clear();
        if (storyHandler != null && this.tagsToExecute.isEmpty() && result.isOk()) {
            if (storyHandler.isFinished() && storyHandler.getDialogText().isEmpty()) {
                storyHandler.stopAndFinishScreen();
            } else if (storyHandler.getDialogText().isEmpty() && storyHandler.getStory().canContinue()) {
                storyHandler.next();
            } else if (!storyHandler.isFinished() && storyHandler.getDialogText().isEmpty() && storyHandler.getStory().getCurrentChoices().isEmpty() && !this.playerSession.isOnGameplay()) {
                storyHandler.next();
                this.run = null;
            } else {
                storyHandler.showCurrentDialog();
            }
        }
        if (this.run != null) {
            this.run.run();
        }
    }

    public void stopAll() {
        for (InkAction inkAction : this.playerSession.getInkActions()) {
            inkAction.stop();
        }
    }

    public PlayerSession getPlayerSession() {
        return this.playerSession;
    }

    public List<String> getTagsToExecute() {
        return this.tagsToExecute;
    }

    public Runnable getRun() {
        return this.run;
    }

    public void setRun(Runnable run) {
        this.run = run;
    }
}

