/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.BreakBlockAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PlaceBlockAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class ActionsData {
    private transient class_1297 entity;
    private final int entityId;
    private int entityIdRecording;
    private int spawnTick;
    private String nbtData;
    private final List<Location> locations = new ArrayList<Location>();
    private final List<Action> actions = new ArrayList<Action>();

    public ActionsData(class_1297 entity, int spawnTick) {
        this.entity = entity;
        if (!(entity instanceof class_3222)) {
            this.nbtData = String.valueOf(this.serializeNBT());
        }
        this.entityId = class_7923.field_41177.method_10206((Object)entity.method_5864());
        this.spawnTick = spawnTick;
        this.entityIdRecording = -1;
    }

    private class_2487 serializeNBT() {
        class_2487 compoundTag = this.entity.method_5647(new class_2487());
        compoundTag.method_10551("UUID");
        compoundTag.method_10551("Pos");
        compoundTag.method_10551("Motion");
        return compoundTag;
    }

    public void addLocation() {
        Location currentLoc = new Location(this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), this.entity.method_36455(), this.entity.method_36454(), this.entity.method_24828());
        this.locations.add(currentLoc);
    }

    public void reset(class_1297 entity) {
        PlaybackData playbackData = new PlaybackData(this, null);
        playbackData.setEntity(entity);
        HashMap<class_2338, Action> latestActions = new HashMap<class_2338, Action>();
        for (Action action : this.actions) {
            class_2338 pos = this.getPosFromAction(action);
            if (pos == null) continue;
            latestActions.putIfAbsent(pos, action);
        }
        for (Map.Entry entry : latestActions.entrySet()) {
            Action action = (Action)entry.getValue();
            if (action instanceof PlaceBlockAction) {
                PlaceBlockAction place = (PlaceBlockAction)action;
                place.rewind(playbackData);
                continue;
            }
            if (!(action instanceof BreakBlockAction)) continue;
            BreakBlockAction breakBlockAction = (BreakBlockAction)action;
            breakBlockAction.rewind(playbackData);
        }
    }

    private class_2338 getPosFromAction(Action action) {
        if (action instanceof PlaceBlockAction) {
            PlaceBlockAction p = (PlaceBlockAction)action;
            return p.getBlockPos();
        }
        if (action instanceof BreakBlockAction) {
            BreakBlockAction b = (BreakBlockAction)action;
            return b.getBlockPos();
        }
        return null;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public void setEntity(class_1309 entity) {
        this.entity = entity;
    }

    public int getSpawnTick() {
        return this.spawnTick;
    }

    public void setSpawnTick(int spawnTick) {
        this.spawnTick = spawnTick;
    }

    public int getEntityIdRecording() {
        return this.entityIdRecording;
    }

    public void setEntityIdRecording(int entityIdRecording) {
        this.entityIdRecording = entityIdRecording;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getNbtData() {
        return this.nbtData;
    }
}

