/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.session;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.gui.StorySaveIconGui;
import fr.loudo.narrativecraft.managers.PlaybackManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.StitchInteraction;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.inkTag.InkTagHandler;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.inkAction.GameplayInkAction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_3222;

public class PlayerSession {
    private final class_3222 player;
    private final PlaybackManager playbackManager = new PlaybackManager();
    private final List<InkAction> inkActions = new ArrayList<InkAction>();
    private final List<CharacterRuntime> characterRuntimes = new ArrayList<CharacterRuntime>();
    private final InkTagHandler inkTagHandler;
    private final StorySaveIconGui storySaveIconGui = new StorySaveIconGui(0.2, 0.9, 0.2);
    private final List<InteractionController> interactionControllers = new ArrayList<InteractionController>();
    private final List<AreaTrigger> areaTriggersEntered = new ArrayList<AreaTrigger>();
    private AbstractController controller;
    private DialogRenderer dialogRenderer;
    private KeyframeLocation currentCamera;
    private StoryHandler storyHandler;
    private AreaTrigger lastAreaTriggerEntered;
    private StitchInteraction lastInteraction;
    private Chapter chapter;
    private Scene scene;
    private String stitch;
    private class_1934 lastGameType;
    private int lookingAtEntityId;
    private boolean showDebugHud;

    public PlayerSession(class_3222 player) {
        this.player = player;
        this.inkTagHandler = new InkTagHandler(this);
    }

    public PlayerSession(class_3222 player, Chapter chapter, Scene scene) {
        this.player = player;
        this.chapter = chapter;
        this.scene = scene;
        this.inkTagHandler = new InkTagHandler(this);
    }

    public void addInkAction(InkAction inkAction) {
        if (this.inkActions.contains(inkAction)) {
            return;
        }
        this.inkActions.add(inkAction);
    }

    public void removeInkAction(InkAction inkAction) {
        this.inkActions.remove(inkAction);
    }

    public boolean isSamePlayer(class_1657 player) {
        if (player == null) {
            return false;
        }
        return this.player.method_5667().equals(player.method_5667());
    }

    public boolean isSessionSet() {
        return this.chapter != null && this.scene != null;
    }

    public void reset() {
        this.chapter = null;
        this.scene = null;
    }

    public Location getPlayerPosition() {
        return new Location(this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), this.player.method_36455(), this.player.method_36454(), this.player.method_24828());
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public PlaybackManager getPlaybackManager() {
        return this.playbackManager;
    }

    public List<InkAction> getInkActions() {
        return this.inkActions;
    }

    public List<InkAction> getClientSideInkActions() {
        try {
            return this.inkActions.stream().filter(inkAction -> inkAction.getSide() != null && inkAction.getSide() == InkAction.Side.CLIENT).toList();
        }
        catch (Exception e) {
            return new ArrayList<InkAction>();
        }
    }

    public List<InkAction> getServerSideInkActions() {
        try {
            return this.inkActions.stream().filter(inkAction -> inkAction.getSide() != null && inkAction.getSide() == InkAction.Side.SERVER).toList();
        }
        catch (Exception e) {
            return new ArrayList<InkAction>();
        }
    }

    public InkTagHandler getInkTagHandler() {
        return this.inkTagHandler;
    }

    public List<CharacterRuntime> getCharacterRuntimesByCharacter(CharacterStory characterStory) {
        this.clearKilledCharacters();
        ArrayList<CharacterRuntime> characterRuntimes1 = new ArrayList<CharacterRuntime>();
        for (CharacterRuntime characterRuntime : this.characterRuntimes) {
            if (characterRuntime.getEntity() == null || characterRuntime.getEntity().method_31481() || !characterRuntime.getCharacterStory().getName().equalsIgnoreCase(characterStory.getName())) continue;
            characterRuntimes1.add(characterRuntime);
        }
        return characterRuntimes1;
    }

    public void clearKilledCharacters() {
        this.characterRuntimes.removeIf(characterRuntime -> characterRuntime.getEntity() == null || characterRuntime.getEntity().method_31481());
    }

    public void clearPlaybacksNotPlaying() {
        this.playbackManager.getPlaybacks().removeIf(playback -> playback.hasEnded() || playback.getCharacterRuntime().getEntity() == null || playback.getCharacterRuntime().getEntity().method_31481());
    }

    public boolean isOnGameplay() {
        ArrayList<InkAction> inkActions1 = new ArrayList<InkAction>(this.inkActions);
        return !inkActions1.stream().filter(inkAction -> inkAction instanceof GameplayInkAction).toList().isEmpty();
    }

    public List<AreaTrigger> getAreaTriggersEntered() {
        return this.areaTriggersEntered;
    }

    public void addAreaTriggerEntered(AreaTrigger areaTrigger) {
        if (this.areaTriggersEntered.contains(areaTrigger)) {
            return;
        }
        this.areaTriggersEntered.add(areaTrigger);
    }

    public void removeAreaTriggerEntered(AreaTrigger areaTrigger) {
        this.areaTriggersEntered.remove(areaTrigger);
    }

    public AreaTrigger getLastAreaTriggerEntered() {
        return this.lastAreaTriggerEntered;
    }

    public StitchInteraction getLastInteraction() {
        return this.lastInteraction;
    }

    public void setLastInteraction(StitchInteraction lastInteraction) {
        this.lastInteraction = lastInteraction;
    }

    public void setLastAreaTriggerEntered(AreaTrigger lastAreaTriggerEntered) {
        this.lastAreaTriggerEntered = lastAreaTriggerEntered;
    }

    public List<CharacterRuntime> getCharacterRuntimes() {
        return this.characterRuntimes;
    }

    public DialogRenderer getDialogRenderer() {
        return this.dialogRenderer;
    }

    public void setDialogRenderer(DialogRenderer dialogRenderer) {
        this.dialogRenderer = dialogRenderer;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public String getStitch() {
        return this.stitch;
    }

    public void setStitch(String stitch) {
        this.stitch = stitch;
    }

    public int getLookingAtEntityId() {
        return this.lookingAtEntityId;
    }

    public void setLookingAtEntityId(int lookingAtEntityId) {
        this.lookingAtEntityId = lookingAtEntityId;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    public KeyframeLocation getCurrentCamera() {
        return this.currentCamera;
    }

    public StoryHandler getStoryHandler() {
        return this.storyHandler;
    }

    public void setStoryHandler(StoryHandler storyHandler) {
        this.storyHandler = storyHandler;
    }

    public void setCurrentCamera(KeyframeLocation currentCamera) {
        this.currentCamera = currentCamera;
        if (currentCamera == null) {
            if (this.lastGameType != null) {
                this.player.method_7336(this.lastGameType);
            }
            return;
        }
        if (this.player.field_13974.method_14257() != class_1934.field_9219) {
            this.lastGameType = this.player.field_13974.method_14257();
        }
        this.player.method_7336(class_1934.field_9219);
    }

    public StorySaveIconGui getStorySaveIconGui() {
        return this.storySaveIconGui;
    }

    public boolean isShowDebugHud() {
        return this.showDebugHud;
    }

    public void setShowDebugHud(boolean showDebugHud) {
        this.showDebugHud = showDebugHud;
    }

    public List<InteractionController> getInteractionControllers() {
        return this.interactionControllers;
    }
}

