/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.managers.PlaybackManager;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.class_2561;

public class AnimationInkAction
extends InkAction {
    private Animation animation;
    private Playback playback;
    private String action;
    private boolean isLooping;
    private boolean isBlock;
    private boolean isUnique;

    public AnimationInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (this.playback == null) {
            this.isRunning = false;
            return;
        }
        if (!this.isRunning && this.blockEndTask != null) {
            this.blockEndTask.run();
            return;
        }
        this.isRunning = !this.playback.hasEnded();
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() < 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Action start or stop"));
        }
        this.action = arguments.get(1);
        if (!this.action.equals("start") && !this.action.equals("stop")) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", "Only start or stop as action"));
        }
        if (arguments.size() < 3) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Animation name"));
        }
        String animationName = arguments.get(2);
        this.animation = scene.getAnimationByName(animationName);
        if (this.animation == null) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", Translation.message("animation.no_exists", animationName, scene.getName())));
        }
        this.isLooping = InkUtil.getOptionalArgument(this.command, "loop");
        this.isLooping = InkUtil.getOptionalArgument(this.command, "unique");
        this.isLooping = InkUtil.getOptionalArgument(this.command, "loop");
        this.canBeExecuted = true;
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        if (this.action.equals("start")) {
            this.playback = new Playback(PlaybackManager.ID_INCREMENTER.incrementAndGet(), this.animation, playerSession.getPlayer().method_37908(), Environment.PRODUCTION, this.isLooping);
            StoryHandler storyHandler = playerSession.getStoryHandler();
            if (storyHandler != null) {
                this.playback.startFromStory(storyHandler);
            } else {
                this.playback.start();
            }
            this.playback.setUnique(this.isUnique);
            playerSession.getPlaybackManager().addPlayback(this.playback);
            playerSession.getCharacterRuntimes().add(this.playback.getCharacterRuntime());
            playerSession.clearKilledCharacters();
        } else if (this.action.equals("stop")) {
            Playback playback = playerSession.getPlaybackManager().getPlayback(this.animation.getName());
            if (playback == null) {
                return InkActionResult.ignored();
            }
            playerSession.getCharacterRuntimes().remove(playback.getCharacterRuntime());
            playback.stop(true);
        }
        return this.isBlock ? InkActionResult.block() : InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return true;
    }
}

