/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.inkAction.CameraAngleInkAction;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public class GameplayInkAction
extends InkAction {
    public GameplayInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof GameplayInkAction);
        CharacterStory mainCharacter = NarrativeCraftMod.getInstance().getCharacterManager().getMainCharacter();
        if (mainCharacter == null) {
            return InkActionResult.error("A main character assigned is required for this tag to work!");
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            return InkActionResult.ignored();
        }
        if (playerSession.getDialogRenderer() != null) {
            playerSession.getDialogRenderer().setRunDialogStopped(() -> {
                playerSession.setDialogRenderer(null);
                this.execute(playerSession);
                playerSession.getInkActions().add(this);
            });
            playerSession.getDialogRenderer().stop();
            return InkActionResult.ok();
        }
        if (storyHandler.characterInStory(mainCharacter)) {
            List<CharacterRuntime> characterRuntimes = storyHandler.getCharacterRuntimeFromCharacter(mainCharacter);
            if (characterRuntimes.isEmpty()) {
                return InkActionResult.error("Main character was found in the story, but his entity was not...");
            }
            class_243 position = characterRuntimes.getFirst().getEntity().method_19538();
            class_1309 entity = characterRuntimes.getFirst().getEntity();
            playerSession.getPlayer().field_13987.method_14363(position.field_1352, position.field_1351, position.field_1350, entity.method_36454(), entity.method_36455());
            storyHandler.killCharacter(mainCharacter);
        }
        if (playerSession.getController() != null) {
            playerSession.getController().stopSession(false);
        }
        playerSession.setCurrentCamera(null);
        playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof CameraAngleInkAction);
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

