/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class MinecraftCommandInkAction
extends InkAction {
    private String command;

    public MinecraftCommandInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Command value"));
        }
        this.command = arguments.get(1);
        this.command = this.command.replace("\\{", "{");
        this.command = this.command.replace("\\}", "}");
        class_2168 commandSourceStack = new class_2168(null, null, null, null, 4, null, null, NarrativeCraftMod.server, null);
        ParseResults parse = NarrativeCraftMod.server.method_3734().method_9235().parse(new StringReader(this.command), (Object)commandSourceStack);
        if (parse.getReader().canRead() && parse.getExceptions().size() == 1) {
            String commandError = ((CommandSyntaxException)((Object)parse.getExceptions().values().iterator().next())).getMessage();
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", "Command can't be executed: " + commandError));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        class_2168 commandSourceStack = this.getCommandSourceStack(playerSession);
        this.command = this.command.replace("@p", playerSession.getPlayer().method_5477().getString());
        try {
            playerSession.getPlayer().method_37908().method_8503().method_3734().method_9235().execute(this.command, (Object)commandSourceStack);
        }
        catch (CommandSyntaxException e) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", "Command can't be executed: " + e.getMessage()));
        }
        this.isRunning = false;
        return InkActionResult.ok();
    }

    private class_2168 getCommandSourceStack(PlayerSession playerSession) {
        class_3222 player = playerSession.getPlayer();
        class_2165 commandSource = class_2165.field_17395;
        return new class_2168(commandSource, player.method_19538(), player.method_5802(), (class_3218)player.method_37908(), 4, player.method_5477().getString(), player.method_5476(), player.method_37908().method_8503(), (class_1297)player);
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

