/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.text;

import fr.loudo.narrativecraft.narrative.dialog.DialogAnimationType;
import fr.loudo.narrativecraft.narrative.dialog.DialogLetterEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public record TextEffect(DialogAnimationType type, int startIndex, int endIndex, Map<String, String> parameters) {
    public static List<DialogLetterEffect> apply(List<TextEffect> effects) {
        ArrayList<DialogLetterEffect> dialogLetterEffectList = new ArrayList<DialogLetterEffect>();
        if (effects.isEmpty()) {
            return dialogLetterEffectList;
        }
        for (TextEffect effect : effects) {
            double time = 0.0;
            float force = 0.0f;
            try {
                time = Double.parseDouble(effect.parameters().getOrDefault("time", "-1"));
                force = Float.parseFloat(effect.parameters().getOrDefault("force", "-1"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (effect.type()) {
                case WAVE: {
                    time = time == -1.0 ? 0.3 : time;
                    force = force == -1.0f ? 1.0f : force;
                    break;
                }
                case SHAKE: {
                    time = time == -1.0 ? 0.05 : time;
                    force = force == -1.0f ? 0.35f : force;
                    break;
                }
                case WAIT: {
                    time = time == -1.0 ? 0.0 : time;
                }
            }
            dialogLetterEffectList.add(new DialogLetterEffect(effect.type(), time, force, effect.startIndex(), effect.endIndex()));
        }
        return dialogLetterEffectList;
    }
}

