/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.chapter;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.ChapterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class EditScreenChapterAdapter
implements EditScreenAdapter<Chapter> {
    @Override
    public void initExtraFields(EditInfoScreen<Chapter> screen, Chapter entry) {
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Chapter> screen, Chapter entry, int startY, int centerX) {
    }

    @Override
    public void buildFromScreen(class_437 screen, Map<String, Object> extraFields, class_310 minecraft, @Nullable Chapter existing, String name, String description) {
        if (existing == null) {
            ChapterManager chapterManager = NarrativeCraftMod.getInstance().getChapterManager();
            if (chapterManager.chapterExists(name)) {
                ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("chapter.already_exists", name));
                return;
            }
            Chapter chapter = new Chapter(name, description, chapterManager.getChapters().size() + 1);
            try {
                chapterManager.addChapter(chapter);
                NarrativeCraftFile.createChapterDirectory(chapter);
                minecraft.method_1507((class_437)new ChaptersScreen());
            }
            catch (Exception e) {
                chapterManager.removeChapter(chapter);
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        } else {
            Chapter newChapter = new Chapter(name, description, existing.getIndex());
            Chapter oldChapter = new Chapter(existing.getName(), existing.getDescription(), existing.getIndex());
            try {
                NarrativeCraftFile.updateChapterData(newChapter);
                existing.setName(name);
                existing.setDescription(description);
                NarrativeCraftFile.updateInkIncludes();
                minecraft.method_1507((class_437)new ChaptersScreen());
            }
            catch (Exception e) {
                existing.setName(oldChapter.getName());
                existing.setDescription(oldChapter.getDescription());
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        }
    }
}

