/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.character;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterModel;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.narrative.character.MainCharacterAttribute;
import fr.loudo.narrativecraft.screens.characters.CharacterAdvancedScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.character.CharactersScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import org.jetbrains.annotations.Nullable;

public class EditScreenCharacterAdapter
implements EditScreenAdapter<CharacterStory> {
    private final Scene scene;
    private MainCharacterAttribute attribute;

    public EditScreenCharacterAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<CharacterStory> screen, CharacterStory entry) {
        if (this.scene == null) {
            LocalDate localDate = LocalDate.now();
            ScreenUtils.LabelBox dayLabelBox = new ScreenUtils.LabelBox((class_2561)class_2561.method_43470((String)"Day"), screen.getFont(), 20, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            screen.extraFields.put("day", dayLabelBox);
            screen.extraFields.put("dayBox", dayLabelBox.getEditBox());
            dayLabelBox.getEditBox().method_1890(string -> string.matches("^\\d*$"));
            dayLabelBox.getEditBox().method_1852(String.valueOf(localDate.getDayOfMonth()));
            ScreenUtils.LabelBox monthLabelBox = new ScreenUtils.LabelBox((class_2561)class_2561.method_43470((String)"Month"), screen.getFont(), 20, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            monthLabelBox.getEditBox().method_1890(string -> string.matches("^\\d*$"));
            monthLabelBox.getEditBox().method_1852(String.valueOf(localDate.getMonthValue()));
            screen.extraFields.put("month", monthLabelBox);
            ScreenUtils.LabelBox yearLabelBox = new ScreenUtils.LabelBox((class_2561)class_2561.method_43470((String)"Year"), screen.getFont(), 32, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            yearLabelBox.getEditBox().method_1890(string -> string.matches("^\\d*$"));
            yearLabelBox.getEditBox().method_1852("2000");
            screen.extraFields.put("year", yearLabelBox);
        }
        class_4185 modelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)CharacterModel.WIDE.name()), button -> {
            String currentModel = button.method_25369().getString();
            if (currentModel.equalsIgnoreCase(CharacterModel.WIDE.name())) {
                button.method_25355((class_2561)class_2561.method_43470((String)CharacterModel.SLIM.name()));
            } else {
                button.method_25355((class_2561)class_2561.method_43470((String)CharacterModel.WIDE.name()));
            }
        }).method_46432(70).method_46431();
        screen.extraFields.put("modelBtn", modelButton);
        if (this.attribute == null && this.scene == null) {
            this.attribute = entry == null ? new MainCharacterAttribute() : new MainCharacterAttribute(entry.getMainCharacterAttribute());
        }
        if (entry != null) {
            if (this.scene == null) {
                String[] birthDateSplit = entry.getBirthDate().split("/");
                try {
                    ScreenUtils.LabelBox dayLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("day");
                    ScreenUtils.LabelBox monthLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("month");
                    ScreenUtils.LabelBox yearLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("year");
                    dayLabelBox.getEditBox().method_1852(birthDateSplit[0]);
                    monthLabelBox.getEditBox().method_1852(birthDateSplit[1]);
                    yearLabelBox.getEditBox().method_1852(birthDateSplit[2]);
                }
                catch (Exception e) {
                    Util.sendCrashMessage((class_1657)class_310.method_1551().field_1724, e);
                    class_310.method_1551().method_1507(null);
                }
            }
            modelButton.method_25355((class_2561)class_2561.method_43470((String)entry.getModel().name()));
        }
    }

    @Override
    public void renderExtraFields(EditInfoScreen<CharacterStory> screen, CharacterStory entry, int x, int y) {
        if (this.scene == null) {
            ScreenUtils.LabelBox dayLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("day");
            dayLabelBox.setPosition(x, y);
            screen.method_37063((CharacterStory)dayLabelBox.getEditBox());
            screen.method_37063((CharacterStory)dayLabelBox.getStringWidget());
            ScreenUtils.LabelBox monthLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("month");
            monthLabelBox.setPosition(dayLabelBox.getEditBox().method_46426() + dayLabelBox.getEditBox().method_25368() + 10, y);
            screen.method_37063((CharacterStory)monthLabelBox.getEditBox());
            screen.method_37063((CharacterStory)monthLabelBox.getStringWidget());
            ScreenUtils.LabelBox yearLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("year");
            yearLabelBox.setPosition(monthLabelBox.getEditBox().method_46426() + monthLabelBox.getEditBox().method_25368() + 10, y);
            screen.method_37063((CharacterStory)yearLabelBox.getEditBox());
            screen.method_37063((CharacterStory)yearLabelBox.getStringWidget());
            y += yearLabelBox.getEditBox().method_25364() + screen.GAP;
        }
        class_4185 modelButton = (class_4185)screen.extraFields.get("modelBtn");
        class_5250 label = class_2561.method_43470((String)"Model");
        class_327 class_3272 = screen.getFont();
        int n = y + modelButton.method_25364() / 2;
        Objects.requireNonNull(screen.getFont());
        class_7842 modelText = ScreenUtils.text((class_2561)label, class_3272, x, n - 9 / 2);
        screen.method_37063((CharacterStory)modelText);
        screen.method_37063((CharacterStory)modelButton);
        modelButton.method_48229(x + modelText.method_25368() + 5, y);
        if (entry != null) {
            class_4185 advancedBtn = class_4185.method_46430((class_2561)Translation.message("global.advanced", new Object[0]), button -> {
                screen.setName(screen.getNameBox().getEditBox().method_1882());
                screen.setDescription(screen.getDescriptionBox().getMultiLineEditBox().method_44405());
                CharacterAdvancedScreen screen1 = new CharacterAdvancedScreen(screen, entry);
                minecraft.method_1507((class_437)screen1);
            }).method_46432(83).method_46431();
            advancedBtn.method_48229(modelButton.method_46426() + modelButton.method_25368() + 5, y);
            screen.method_37063((CharacterStory)advancedBtn);
        }
    }

    @Override
    public void buildFromScreen(class_437 screen, Map<String, Object> extraFields, class_310 minecraft, @Nullable CharacterStory existing, String name, String description) {
        CharacterStory newCharacter;
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        CharacterStory currentMainCharacter = characterManager.getMainCharacter();
        CharacterModel model = CharacterModel.valueOf(((class_4185)extraFields.get("modelBtn")).method_25369().getString());
        if (this.scene == null) {
            String day = ((ScreenUtils.LabelBox)extraFields.get("day")).getEditBox().method_1882();
            String month = ((ScreenUtils.LabelBox)extraFields.get("month")).getEditBox().method_1882();
            String year = ((ScreenUtils.LabelBox)extraFields.get("year")).getEditBox().method_1882();
            newCharacter = new CharacterStory(name, description, day, month, year, model, CharacterType.MAIN);
        } else {
            newCharacter = new CharacterStory(name, description, "You", "are", "handsome <3", model, CharacterType.NPC);
        }
        if (existing == null) {
            if (characterManager.characterExists(name)) {
                ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("character.already_exists", name));
                return;
            }
            try {
                if (this.scene == null) {
                    if (characterManager.getCharacterStories().isEmpty()) {
                        newCharacter.getMainCharacterAttribute().setMainCharacter(true);
                    }
                    NarrativeCraftFile.createCharacterFolder(newCharacter);
                    characterManager.addCharacter(newCharacter);
                } else {
                    NarrativeCraftFile.createCharacterFolder(newCharacter, this.scene);
                    this.scene.addNpc(newCharacter);
                }
                newCharacter.setMainCharacterAttribute(this.attribute);
                this.updateMainCharacter(currentMainCharacter, newCharacter);
                minecraft.method_1507((class_437)new CharactersScreen(this.scene));
            }
            catch (Exception e) {
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        } else {
            List<Chapter> chapters = NarrativeCraftMod.getInstance().getChapterManager().getChapters();
            try {
                newCharacter.setShowNametag(existing.showNametag());
                if (this.scene == null) {
                    newCharacter.setMainCharacterAttribute(existing.getMainCharacterAttribute());
                    NarrativeCraftFile.updateCharacterData(existing, newCharacter);
                } else {
                    newCharacter.setMainCharacterAttribute(null);
                    NarrativeCraftFile.updateCharacterData(existing, newCharacter, this.scene);
                }
                existing.setName(newCharacter.getName());
                existing.setDescription(newCharacter.getDescription());
                existing.setMainCharacterAttribute(newCharacter.getMainCharacterAttribute());
                existing.setShowNametag(newCharacter.showNametag());
                if (this.scene == null) {
                    existing.setBirthDate(newCharacter.getBirthDate());
                }
                existing.setModel(newCharacter.getModel());
                for (Chapter chapter : chapters) {
                    for (Scene scene : chapter.getSortedSceneList()) {
                        for (Animation animation : scene.getAnimations()) {
                            NarrativeCraftFile.updateAnimationFile(animation);
                        }
                        NarrativeCraftFile.updateCameraAngles(scene);
                    }
                }
                this.updateMainCharacter(currentMainCharacter, newCharacter);
                minecraft.method_1507((class_437)new CharactersScreen(this.scene));
            }
            catch (Exception e) {
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        }
    }

    private void updateMainCharacter(CharacterStory currentMainCharacter, CharacterStory newCharacter) throws IOException {
        if (this.attribute == null) {
            return;
        }
        if (currentMainCharacter != null && this.attribute.isMainCharacter() && !currentMainCharacter.getName().equalsIgnoreCase(newCharacter.getName())) {
            currentMainCharacter.getMainCharacterAttribute().setMainCharacter(false);
            NarrativeCraftFile.updateCharacterData(currentMainCharacter, currentMainCharacter);
        }
    }
}

