/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.cutscene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.cutscene.CutscenesScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class EditScreenCutsceneAdapter
implements EditScreenAdapter<Cutscene> {
    private final Scene scene;

    public EditScreenCutsceneAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<Cutscene> screen, Cutscene entry) {
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Cutscene> screen, Cutscene entry, int x, int y) {
    }

    @Override
    public void buildFromScreen(class_437 screen, Map<String, Object> extraFields, class_310 minecraft, @Nullable Cutscene existing, String name, String description) {
        if (existing == null) {
            if (this.scene.cutsceneExists(name)) {
                ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("cutscene.already_exists", name, this.scene.getName()));
                return;
            }
            Cutscene cutscene = new Cutscene(name, description, this.scene);
            try {
                this.scene.addCutscene(cutscene);
                NarrativeCraftFile.updateCutsceneFile(this.scene);
                minecraft.method_1507((class_437)new CutscenesScreen(this.scene));
            }
            catch (Exception e) {
                this.scene.removeCutscene(cutscene);
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        } else {
            Cutscene oldCutscene = new Cutscene(existing.getName(), existing.getDescription(), this.scene);
            try {
                existing.setName(name);
                existing.setDescription(description);
                NarrativeCraftFile.updateCutsceneFile(this.scene);
                minecraft.method_1507((class_437)new CutscenesScreen(this.scene));
            }
            catch (Exception e) {
                existing.setName(oldCutscene.getName());
                existing.setDescription(oldCutscene.getDescription());
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        }
    }
}

