/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.interaction;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.interaction.InteractionsScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class EditScreenInteractionAdapter
implements EditScreenAdapter<Interaction> {
    private final Scene scene;

    public EditScreenInteractionAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<Interaction> screen, Interaction entry) {
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Interaction> screen, Interaction entry, int x, int y) {
    }

    @Override
    public void buildFromScreen(class_437 screen, Map<String, Object> extraFields, class_310 minecraft, @Nullable Interaction existing, String name, String description) {
        if (existing == null) {
            if (this.scene.interactionExists(name)) {
                ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("interaction.already_exists", name, this.scene.getName()));
                return;
            }
            Interaction interaction = new Interaction(name, description, this.scene);
            try {
                this.scene.addInteraction(interaction);
                NarrativeCraftFile.updateInteractionsFile(this.scene);
                minecraft.method_1507((class_437)new InteractionsScreen(this.scene));
            }
            catch (IOException e) {
                this.scene.removeInteraction(interaction);
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        } else {
            Interaction oldInteraction = new Interaction(existing.getName(), existing.getDescription(), this.scene);
            try {
                existing.setName(name);
                existing.setDescription(description);
                NarrativeCraftFile.updateInteractionsFile(this.scene);
                minecraft.method_1507((class_437)new InteractionsScreen(this.scene));
            }
            catch (Exception e) {
                existing.setName(oldInteraction.getName());
                existing.setDescription(oldInteraction.getDescription());
                Util.sendCrashMessage((class_1657)minecraft.field_1724, e);
                minecraft.method_1507(null);
            }
        }
    }
}

