/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import java.lang.reflect.Type;

public class SubsceneSerializer
implements JsonSerializer<Subscene>,
JsonDeserializer<Subscene> {
    private final String animationsKey = "animations_name";
    private final Scene scene;

    public SubsceneSerializer(Scene scene) {
        this.scene = scene;
    }

    public JsonElement serialize(Subscene subscene, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new Gson().toJsonTree((Object)subscene).getAsJsonObject();
        JsonArray animationsArray = new JsonArray();
        for (String name : subscene.getAnimationsName()) {
            animationsArray.add(name);
        }
        obj.add("animations_name", (JsonElement)animationsArray);
        return obj;
    }

    public Subscene deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        Subscene subscene = (Subscene)new Gson().fromJson(json, Subscene.class);
        subscene.setScene(this.scene);
        if (obj.has("animations_name")) {
            for (JsonElement e : obj.getAsJsonArray("animations_name")) {
                String animationName = e.getAsString();
                Animation animation = this.scene.getAnimationByName(animationName);
                if (animation == null) continue;
                subscene.getAnimations().add(animation);
            }
        }
        return subscene;
    }
}

