/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractController {
    protected final List<CharacterStoryData> characterStoryDataList = new ArrayList<CharacterStoryData>();
    protected final Environment environment;
    protected final PlayerSession playerSession;
    protected String hudMessage;

    public AbstractController(Environment environment, Player player) {
        this.environment = environment;
        this.playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer(player);
    }

    public abstract void startSession();

    public abstract void stopSession(boolean var1);

    public abstract Screen getControllerScreen();

    protected void stopCurrentSession() {
        AbstractController controller = this.playerSession.getController();
        if (controller == null) {
            return;
        }
        controller.stopSession(false);
    }

    public void renderHUDInfo(GuiGraphics guiGraphics) {
        if (this.playerSession.getCurrentCamera() != null || this.environment != Environment.DEVELOPMENT) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        int width = minecraft.getWindow().getGuiScaledWidth();
        guiGraphics.drawString(font, this.hudMessage, width / 2 - font.width(this.hudMessage) / 2, 10, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    public CharacterStoryData getCharacterStoryDataFromEntity(Entity entity) {
        for (CharacterStoryData characterStoryData : this.characterStoryDataList) {
            if (!Util.isSameEntity(entity, (Entity)characterStoryData.getCharacterRuntime().getEntity())) continue;
            return characterStoryData;
        }
        return null;
    }

    public CharacterRuntime getCharacterFromEntity(Entity entity) {
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!Util.isSameEntity(entity, (Entity)characterRuntime.getEntity())) continue;
            return characterRuntime;
        }
        return null;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PlayerSession getPlayerSession() {
        return this.playerSession;
    }

    public List<CharacterStoryData> getCharacterStoryDataList() {
        return this.characterStoryDataList;
    }

    public void removeCharacterStoryData(CharacterStoryData characterStoryData) {
        this.characterStoryDataList.remove(characterStoryData);
    }
}

