/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.interaction;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.CharacterInteraction;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.EntityInteraction;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.screens.controller.areaTrigger.AreaTriggerControllerScreen;
import fr.loudo.narrativecraft.screens.controller.interaction.InteractionControllerScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class InteractionController
extends AbstractController {
    private final Interaction interaction;
    private final List<CharacterInteraction> characterInteractions;
    private final List<EntityInteraction> entityInteractions;
    private final List<AreaTrigger> areaTriggers;
    private AreaTrigger areaTriggerEditing;

    public InteractionController(Environment environment, Player player, Interaction interaction) {
        super(environment, player);
        this.interaction = interaction;
        this.characterInteractions = new ArrayList<CharacterInteraction>(interaction.getCharacterInteractions());
        this.entityInteractions = new ArrayList<EntityInteraction>(interaction.getEntityInteractions());
        this.areaTriggers = new ArrayList<AreaTrigger>(interaction.getAreaTriggers());
    }

    public void showAreaTriggers(PoseStack poseStack) {
        if (this.environment != Environment.DEVELOPMENT) {
            return;
        }
        for (AreaTrigger areaTrigger : this.areaTriggers) {
            areaTrigger.drawSquareLine(poseStack);
        }
    }

    @Override
    public void startSession() {
        this.stopCurrentSession();
        this.hudMessage = Translation.message("controller.interaction.hud", this.interaction.getScene().getName()).getString();
        this.playerSession.setController(this);
        for (CharacterInteraction characterInteraction : this.characterInteractions) {
            characterInteraction.getCharacterStoryData().spawn(this.playerSession.getPlayer().level(), this.environment);
            this.playerSession.getCharacterRuntimes().add(characterInteraction.getCharacterStoryData().getCharacterRuntime());
        }
        for (EntityInteraction entityInteraction : this.entityInteractions) {
            entityInteraction.spawn(this.playerSession.getPlayer(), this.environment);
        }
        if (this.environment != Environment.DEVELOPMENT) {
            return;
        }
        Location locToTp = null;
        if (!this.interaction.getCharacterInteractions().isEmpty()) {
            locToTp = this.interaction.getCharacterInteractions().get(0).getCharacterStoryData().getLocation();
        } else if (!this.interaction.getEntityInteractions().isEmpty()) {
            vec3 = this.interaction.getEntityInteractions().get(0).getPosition();
            locToTp = new Location(vec3.x(), vec3.y(), vec3.z(), 0.0f, 0.0f, false);
        } else if (!this.areaTriggers.isEmpty()) {
            vec3 = this.areaTriggers.get(0).getPosition1();
            locToTp = new Location(vec3.x(), vec3.y(), vec3.z(), 0.0f, 0.0f, false);
        }
        if (locToTp != null) {
            this.playerSession.getPlayer().teleportTo(locToTp.x(), locToTp.y(), locToTp.z());
        }
    }

    @Override
    public void stopSession(boolean save) {
        for (CharacterInteraction characterInteraction : this.characterInteractions) {
            characterInteraction.getCharacterStoryData().kill();
        }
        for (EntityInteraction entityInteraction : this.entityInteractions) {
            entityInteraction.kill(this.playerSession.getPlayer());
        }
        this.playerSession.setController(null);
        if (this.environment != Environment.DEVELOPMENT) {
            return;
        }
        this.playerSession.getCharacterRuntimes().clear();
        if (save) {
            List<CharacterInteraction> oldCharacterInteractions = this.interaction.getCharacterInteractions();
            List<EntityInteraction> oldEntityInteractions = this.interaction.getEntityInteractions();
            List<AreaTrigger> oldAreaTriggers = this.interaction.getAreaTriggers();
            try {
                this.interaction.setCharacterInteractions(this.characterInteractions);
                this.interaction.setEntityInteractions(this.entityInteractions);
                this.interaction.setAreaTriggers(this.areaTriggers);
                NarrativeCraftFile.updateInteractionsFile(this.interaction.getScene());
                this.playerSession.getPlayer().sendSystemMessage((Component)Translation.message("controller.saved", new Object[0]));
            }
            catch (Exception e) {
                this.interaction.setCharacterInteractions(oldCharacterInteractions);
                this.interaction.setEntityInteractions(oldEntityInteractions);
                this.interaction.setAreaTriggers(oldAreaTriggers);
                Util.sendCrashMessage((Player)this.playerSession.getPlayer(), e);
            }
        }
    }

    @Override
    public Screen getControllerScreen() {
        return this.areaTriggerEditing != null ? new AreaTriggerControllerScreen(this, this.areaTriggerEditing) : new InteractionControllerScreen(this);
    }

    public Interaction getInteraction() {
        return this.interaction;
    }

    public List<EntityInteraction> getEntityInteractions() {
        return this.entityInteractions;
    }

    public List<CharacterInteraction> getCharacterInteractions() {
        return this.characterInteractions;
    }

    @Override
    public CharacterStoryData getCharacterStoryDataFromEntity(Entity entity) {
        for (CharacterInteraction characterInteraction : this.characterInteractions) {
            if (!Util.isSameEntity(entity, (Entity)characterInteraction.getCharacterStoryData().getCharacterRuntime().getEntity())) continue;
            return characterInteraction.getCharacterStoryData();
        }
        return null;
    }

    @Override
    public void removeCharacterStoryData(CharacterStoryData characterStoryData) {
        this.characterInteractions.removeIf(characterInteraction -> characterInteraction.getCharacterStoryData().equals(characterStoryData));
    }

    public EntityInteraction getEntityInteraction(Entity entity) {
        for (EntityInteraction entityInteraction : this.entityInteractions) {
            if (!Util.isSameEntity(entity, (Entity)entityInteraction.getArmorStand())) continue;
            return entityInteraction;
        }
        return null;
    }

    public CharacterInteraction getCharacterInteractionFromCharacter(CharacterStoryData characterStoryData) {
        for (CharacterInteraction characterInteraction : this.characterInteractions) {
            if (!characterInteraction.getCharacterStoryData().equals(characterStoryData)) continue;
            return characterInteraction;
        }
        return null;
    }

    public List<AreaTrigger> getAreaTriggers() {
        return this.areaTriggers;
    }

    public AreaTrigger getAreaTriggerEditing() {
        return this.areaTriggerEditing;
    }

    public void setAreaTriggerEditing(AreaTrigger areaTriggerEditing) {
        this.areaTriggerEditing = areaTriggerEditing;
    }

    public boolean areaTriggerExists(String name) {
        for (AreaTrigger areaTrigger : this.areaTriggers) {
            if (!areaTrigger.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

