/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.keyframe;

import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.keyframe.KeyframeControllerInterface;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractKeyframeController<T extends Keyframe>
extends AbstractController
implements KeyframeControllerInterface<T> {
    protected final List<KeyframeTrigger> keyframeTriggers = new ArrayList<KeyframeTrigger>();
    protected final AtomicInteger keyframesCounter = new AtomicInteger();

    public AbstractKeyframeController(Environment environment, Player player) {
        super(environment, player);
    }

    protected KeyframeLocation getKeyframeLocationFromPlayer() {
        ServerPlayer player = this.playerSession.getPlayer();
        return new KeyframeLocation(player.position().add(0.0, (double)player.getEyeHeight(), 0.0), player.getXRot(), player.getYRot(), 0.0f, 85.0f);
    }

    @Override
    public void setCamera(Keyframe keyframe) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.options.setCameraType(CameraType.FIRST_PERSON);
        if (this.playerSession.getCurrentCamera() != null && keyframe == null) {
            this.playerSession.setCurrentCamera(null);
            minecraft.options.hideGui = false;
            this.showKeyframes(this.playerSession.getPlayer());
            Vec3 pos = this.playerSession.getPlayer().position();
            this.playerSession.getPlayer().teleportTo(pos.x, pos.y - (double)this.playerSession.getPlayer().getEyeHeight(), pos.z);
            return;
        }
        if (keyframe == null) {
            return;
        }
        this.playerSession.setCurrentCamera(keyframe.getKeyframeLocation());
        this.hideKeyframes(this.playerSession.getPlayer());
        minecraft.options.hideGui = true;
        if (this.environment == Environment.DEVELOPMENT) {
            minecraft.execute(() -> minecraft.setScreen(this.keyframeOptionScreen(keyframe, false)));
        }
    }

    @Override
    public KeyframeTrigger getKeyframeTriggerByEntity(Entity entity) {
        for (KeyframeTrigger keyframeTrigger : this.keyframeTriggers) {
            if (!Util.isSameEntity(entity, (Entity)keyframeTrigger.getCamera())) continue;
            return keyframeTrigger;
        }
        return null;
    }

    @Override
    public void addKeyframeTrigger(int tick, String commands) {
        KeyframeTrigger keyframeTrigger = new KeyframeTrigger(this.keyframesCounter.incrementAndGet(), tick, commands, this.getKeyframeLocationFromPlayer());
        keyframeTrigger.showKeyframe(this.playerSession.getPlayer());
        this.keyframeTriggers.add(keyframeTrigger);
    }

    @Override
    public void removeKeyframeTrigger(KeyframeTrigger keyframeTrigger) {
        this.keyframeTriggers.remove(keyframeTrigger);
        keyframeTrigger.hideKeyframe(this.playerSession.getPlayer());
    }

    public abstract Screen keyframeOptionScreen(Keyframe var1, boolean var2);

    public List<KeyframeTrigger> getKeyframeTriggers() {
        return this.keyframeTriggers;
    }
}

