/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.events;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;

public class OnHudRender {
    public static void controllerHudInfo(GuiGraphics guiGraphics) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.getInstance().player);
        if (playerSession == null) {
            return;
        }
        if (playerSession.getController() == null) {
            return;
        }
        playerSession.getController().renderHUDInfo(guiGraphics);
    }

    public static void inkActionRender(GuiGraphics guiGraphics, float partialTick) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.getInstance().player);
        if (playerSession == null) {
            return;
        }
        List<InkAction> inkActionsClient = playerSession.getClientSideInkActions();
        for (InkAction inkAction : inkActionsClient) {
            inkAction.render(guiGraphics, partialTick);
        }
    }

    public static void dialogRender(GuiGraphics guiGraphics, float partialTick) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.getInstance().player);
        if (playerSession == null) {
            return;
        }
        if (playerSession.getDialogRenderer() != null) {
            playerSession.getDialogRenderer().render(guiGraphics, partialTick);
        }
    }

    public static void saveIconRender(GuiGraphics guiGraphics, float partialTick) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.getInstance().player);
        if (playerSession == null) {
            return;
        }
        playerSession.getStorySaveIconGui().render(guiGraphics, partialTick);
    }

    public static void storyDebugRender(GuiGraphics guiGraphics, float partialTick) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.getInstance().player);
        if (playerSession == null) {
            return;
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            return;
        }
        if (!storyHandler.isDebugMode()) {
            return;
        }
        String debugText = "Debug mode";
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, debugText, guiGraphics.guiWidth() - font.width(debugText) - 5, 5, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        if (!playerSession.isShowDebugHud()) {
            return;
        }
        storyHandler.getStoryDebugHud().render(guiGraphics, partialTick);
    }
}

