/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.events;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.interaction.InteractionEyeRenderer;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;

public class OnRenderWorld {
    public static void renderWorld(PoseStack poseStack, float partialTick) {
        AbstractController controller;
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.getInstance().player);
        if (playerSession == null) {
            return;
        }
        Object object = playerSession.getController();
        if (object instanceof CutsceneController) {
            controller = (CutsceneController)object;
            poseStack.pushPose();
            ((CutsceneController)controller).drawLinesBetweenKeyframes(poseStack);
            poseStack.popPose();
        }
        if ((object = playerSession.getController()) instanceof InteractionController) {
            controller = (InteractionController)object;
            poseStack.pushPose();
            ((InteractionController)controller).showAreaTriggers(poseStack);
            poseStack.popPose();
        }
        if (playerSession.getDialogRenderer() != null) {
            poseStack.pushPose();
            playerSession.getDialogRenderer().render(poseStack, partialTick);
            poseStack.popPose();
        }
        List<InkAction> inkActionsClient = playerSession.getClientSideInkActions();
        for (InkAction inkAction : inkActionsClient) {
            inkAction.partialTick(partialTick);
            poseStack.pushPose();
            inkAction.render(poseStack, partialTick);
            poseStack.popPose();
        }
        if (playerSession.getCurrentCamera() == null && playerSession.isOnGameplay()) {
            poseStack.pushPose();
            InteractionEyeRenderer.render(poseStack, partialTick, playerSession.getLookingAtEntityId());
            poseStack.popPose();
        }
    }
}

